/*
 * Decompiled with CFR 0.152.
 */
package cn.adwadg.murasame;

import cn.adwadg.murasame.Registry.ComboStateRegistry;
import cn.adwadg.murasame.Registry.KeyBindings;
import cn.adwadg.murasame.Registry.ModBlocks;
import cn.adwadg.murasame.Registry.ModEntities;
import cn.adwadg.murasame.Registry.ModItems;
import cn.adwadg.murasame.Registry.SERegistry;
import cn.adwadg.murasame.Registry.SlashArtsRegistry;
import cn.adwadg.murasame.Registry.SoundRegistry;
import cn.adwadg.murasame.client.model.ModModelProvider;
import cn.adwadg.murasame.client.renderer.EmbeddedBladeStoneRenderer;
import cn.adwadg.murasame.client.renderer.MurasameSoulRenderer;
import cn.adwadg.murasame.config.ModConfig;
import cn.adwadg.murasame.data.ModAdvancementProvider;
import cn.adwadg.murasame.data.ModWorldGenProvider;
import cn.adwadg.murasame.network.NetworkHandler;
import cn.adwadg.murasame.playerdata.PlayerSoulDataManager;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import mods.flammpfeil.slashblade.SlashBladeCreativeGroup;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="murasame")
public class Murasame {
    public static final String MOD_ID = "murasame";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"murasame");
    public static final RegistryObject<CreativeModeTab> MURASAME_TAB = CREATIVE_MODE_TABS.register("murasame_tab", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.murasame_tab")).withTabsBefore(new ResourceLocation[]{SlashBladeCreativeGroup.SLASHBLADE_GROUP.getId()}).m_257737_(() -> {
        ItemStack stack = new ItemStack((ItemLike)SBItems.slashblade);
        stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(s -> {
            s.setModel(new ResourceLocation(MOD_ID, "models/murasame/murasamemaru_awakened.obj"));
            s.setTexture(new ResourceLocation(MOD_ID, "models/murasame/murasamemaru_awakened.png"));
        });
        return stack;
    }).m_257501_((parameters, output) -> {
        Murasame.fillBlades(output);
        output.m_246326_((ItemLike)ModBlocks.EMBEDDED_STONE_ITEM.get());
        output.m_246326_((ItemLike)ModBlocks.EMPTY_STONE_ITEM.get());
    }).m_257652_());

    private static void fillBlades(CreativeModeTab.Output output) {
        if (Minecraft.m_91087_().m_91403_() != null) {
            BladeModelManager.getClientSlashBladeRegistry().m_6579_().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).filter(entry -> {
                ResourceLocation loc = ResourceLocation.m_135820_((String)((ResourceKey)entry.getKey()).m_135782_().toString());
                return loc != null && loc.m_135827_().equals(MOD_ID);
            }).sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                LOGGER.info("Registering Murasame Slashblade: {}", entry.getKey());
                output.m_246342_(((SlashBladeDefinition)entry.getValue()).getBlade());
            });
        }
    }

    public Murasame() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        CREATIVE_MODE_TABS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(PlayerSoulDataManager.class);
        SERegistry.REGISTRY_KEY2.register(modEventBus);
        ComboStateRegistry.COMBO_STATES.register(modEventBus);
        SlashArtsRegistry.SLASH_ARTS.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.SPEC);
        SoundRegistry.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModBlocks.ITEMS.register(modEventBus);
        ModEntities.BLOCK_ENTITIES.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModEntities.registerAttributes(FMLJavaModLoadingContext.get().getModEventBus());
        modEventBus.addListener(ModModelProvider::registerLayers);
        modEventBus.addListener(this::onClientSetup);
        modEventBus.addListener(this::onGatherData);
        modEventBus.addListener(this::onCommonSetup);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(SoundRegistry::logRegistration);
        NetworkHandler.init();
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture registries = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new ModAdvancementProvider(output, registries, existingFileHelper));
            generator.addProvider(event.includeServer(), (DataProvider)new ModWorldGenProvider(output, registries, existingFileHelper));
        }
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Client setup started");
        if (!ModEntities.MURASAME_SOUL.isPresent()) {
            LOGGER.error("Murasame Soul entity not registered!");
            return;
        }
        event.enqueueWork(() -> {
            try {
                EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.MURASAME_SOUL.get()), MurasameSoulRenderer::new);
                LOGGER.info("Murasame Soul renderer registered successfully");
            }
            catch (Exception e) {
                LOGGER.error("Failed to register Murasame Soul renderer", (Throwable)e);
            }
            LOGGER.info("Registering block entity renderer");
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModEntities.EMBEDDED_STONE_ENTITY.get()), EmbeddedBladeStoneRenderer::new);
        });
    }

    public static void playSound(Player player, SoundEvent sound) {
        if (!player.m_9236_().m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_284548_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, player.m_5720_(), 1.0f, 1.0f);
        }
    }

    @Mod.EventBusSubscriber(modid="murasame", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class KeyRegistration {
        @SubscribeEvent
        public static void registerKeys(RegisterKeyMappingsEvent event) {
            KeyBindings.init();
            event.register(KeyBindings.TOGGLE_KEY);
        }
    }
}

