/*
 * Decompiled with CFR 0.152.
 */
package cn.adwadg.murasame.Slasharts;

import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SpatialParticleEffects {
    private static final Random random = new Random();

    public static void createTimeFreezeEffect(LivingEntity entity) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)entity.m_9236_();
        Vec3 center = entity.m_20182_();
        double radius = 8.0;
        for (int i = 0; i < 120; ++i) {
            double theta = random.nextDouble() * Math.PI * 2.0;
            double phi = random.nextDouble() * Math.PI;
            double r = radius * random.nextDouble();
            double x = center.f_82479_ + r * Math.sin(phi) * Math.cos(theta);
            double y = center.f_82480_ + r * Math.sin(phi) * Math.sin(theta);
            double z = center.f_82481_ + r * Math.cos(phi);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, 1, 0.0, 0.0, 0.0, 0.05);
            if (!(random.nextFloat() < 0.3f)) continue;
            level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, 1, 0.1, 0.1, 0.1, 0.02);
        }
        SpatialParticleEffects.createGroundRingEffect(level, center, radius);
        SpatialParticleEffects.createPlayerAuraEffect(level, entity);
    }

    private static void createGroundRingEffect(ServerLevel level, Vec3 center, double radius) {
        for (int i = 0; i < 36; ++i) {
            double angle = (double)(i * 10) * Math.PI / 180.0;
            double x = center.f_82479_ + radius * Math.cos(angle);
            double z = center.f_82481_ + radius * Math.sin(angle);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123789_, x, center.f_82480_ + 0.1, z, 2, 0.2, 0.0, 0.2, 0.03);
        }
    }

    private static void createPlayerAuraEffect(ServerLevel level, LivingEntity entity) {
        Vec3 pos = entity.m_20182_();
        for (int i = 0; i < 24; ++i) {
            double angle = (double)(i * 15) * Math.PI / 180.0;
            double height = 0.5 + random.nextDouble() * 1.5;
            double offset = 0.8 + random.nextDouble() * 0.4;
            double x = pos.f_82479_ + offset * Math.cos(angle);
            double z = pos.f_82481_ + offset * Math.sin(angle);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123809_, x, pos.f_82480_ + height, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }

    public static void createSpatialCutEffect(LivingEntity entity) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)entity.m_9236_();
        Vec3 center = entity.m_20182_();
        for (int i = 0; i < 16; ++i) {
            float angle = (float)i * 22.5f;
            double rad = Math.toRadians(angle);
            for (double distance = 1.0; distance <= 8.0; distance += 0.5) {
                double x = center.f_82479_ + distance * Math.cos(rad);
                double z = center.f_82481_ + distance * Math.sin(rad);
                level.m_8767_((ParticleOptions)ParticleTypes.f_123766_, x, center.f_82480_ + 1.0, z, 1, 0.1, 0.2, 0.1, 0.05);
                if (!(random.nextFloat() < 0.4f)) continue;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123797_, x, center.f_82480_ + 1.2, z, 1, 0.05, 0.1, 0.05, 0.03);
            }
        }
    }

    public static void createTimeResumeEffect(LivingEntity entity) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)entity.m_9236_();
        Vec3 center = entity.m_20182_();
        AABB area = new AABB(center.f_82479_ - 8.0, center.f_82480_ - 4.0, center.f_82481_ - 8.0, center.f_82479_ + 8.0, center.f_82480_ + 4.0, center.f_82481_ + 8.0);
        for (int i = 0; i < 80; ++i) {
            double z;
            double y;
            double x = center.f_82479_ + (random.nextDouble() - 0.5) * 16.0;
            if (!area.m_82393_(x, y = center.f_82480_ + (random.nextDouble() - 0.5) * 8.0, z = center.f_82481_ + (random.nextDouble() - 0.5) * 16.0)) continue;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 1, 0.1, 0.1, 0.1, 0.08);
        }
        SpatialParticleEffects.createShrinkingAuraEffect(level, center);
    }

    private static void createShrinkingAuraEffect(ServerLevel level, Vec3 center) {
        for (double radius = 8.0; radius > 0.0; radius -= 0.5) {
            for (int i = 0; i < 12; ++i) {
                double angle = (double)(i * 30) * Math.PI / 180.0;
                double x = center.f_82479_ + radius * Math.cos(angle);
                double z = center.f_82481_ + radius * Math.sin(angle);
                level.m_8767_((ParticleOptions)ParticleTypes.f_123771_, x, center.f_82480_ + 1.0, z, 1, 0.05, 0.1, 0.05, 0.04);
            }
        }
    }
}

