/*
 * Decompiled with CFR 0.152.
 */
package cn.adwadg.murasame.Slasharts;

import cn.adwadg.murasame.Slasharts.SpatialParticleEffects;
import java.util.List;
import java.util.WeakHashMap;
import mods.flammpfeil.slashblade.util.AttackManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SpatialSlash {
    private static final WeakHashMap<LivingEntity, Vec3> frozenEntities = new WeakHashMap();
    private static final WeakHashMap<LivingEntity, Vec3> playerOriginalSpeeds = new WeakHashMap();

    public static void doSpatialSlash(LivingEntity entity) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)entity.m_9236_();
        Vec3 center = entity.m_20182_();
        AABB area = new AABB(center.f_82479_ - 8.0, center.f_82480_ - 4.0, center.f_82481_ - 8.0, center.f_82479_ + 8.0, center.f_82480_ + 4.0, center.f_82481_ + 8.0);
        List entities = level.m_45976_(LivingEntity.class, area);
        playerOriginalSpeeds.put(entity, entity.m_20184_());
        Vec3 currentMovement = entity.m_20184_();
        entity.m_20256_(new Vec3(currentMovement.f_82479_ * 0.4, currentMovement.f_82480_, currentMovement.f_82481_ * 0.4));
        for (LivingEntity target : entities) {
            if (target == entity || !target.m_6084_()) continue;
            frozenEntities.put(target, target.m_20184_());
            target.m_20256_(Vec3.f_82478_);
        }
        SpatialParticleEffects.createTimeFreezeEffect(entity);
    }

    public static void releaseSpatialHold(LivingEntity entity) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        SpatialParticleEffects.createTimeResumeEffect(entity);
        for (LivingEntity target : frozenEntities.keySet()) {
            if (target == null || !target.m_6084_()) continue;
            Vec3 originalMovement = frozenEntities.get(target);
            if (originalMovement != null) {
                target.m_20256_(originalMovement);
            }
            target.m_20242_(false);
        }
        frozenEntities.clear();
        Vec3 originalSpeed = playerOriginalSpeeds.get(entity);
        if (originalSpeed != null) {
            entity.m_20256_(originalSpeed);
        }
        playerOriginalSpeeds.remove(entity);
    }

    public static void executeSingleSlash(LivingEntity entity, float angle, float power) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)entity.m_9236_();
        AttackManager.doSlash((LivingEntity)entity, (float)angle, (Vec3)Vec3.f_82478_, (boolean)true, (boolean)false, (double)power);
        int particleCount = (int)(power * 10.0f);
        if (power >= 1.3f) {
            // empty if block
        }
    }
}

