/*
 * Decompiled with CFR 0.152.
 */
package cn.adwadg.murasame.client.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="yourmodid", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CombatTracker {
    private static final Map<UUID, Integer> playerCombatTimers = new HashMap<UUID, Integer>();
    private static final int COMBAT_DURATION = 200;

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        Player player = event.getEntity();
        playerCombatTimers.put(player.m_20148_(), 200);
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            playerCombatTimers.put(player.m_20148_(), 200);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            playerCombatTimers.entrySet().removeIf(entry -> {
                int newTime = (Integer)entry.getValue() - 1;
                if (newTime <= 0) {
                    return true;
                }
                entry.setValue(newTime);
                return false;
            });
        }
    }

    public static boolean isInCombat(Player player) {
        return playerCombatTimers.containsKey(player.m_20148_());
    }

    public static int getCombatTimeLeft(Player player) {
        return playerCombatTimers.getOrDefault(player.m_20148_(), 0);
    }
}

