/*
 * Decompiled with CFR 0.152.
 */
package cn.adwadg.murasame.client.utils;

import cn.adwadg.murasame.Murasame;
import cn.adwadg.murasame.Registry.SoundRegistry;
import cn.adwadg.murasame.config.ModConfig;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;

public class MurasameEvolutionTracker {
    private static final String EVOLVED_TAG = "murasame_evolved";
    public static final int REQUIRED_KILLS = (Integer)ModConfig.EVKILLNEEDED.get();
    public static final int REQUIRED_SOULS = (Integer)ModConfig.EVPSNEEDED.get();

    public static void checkEvolution(Player player, ItemStack stack) {
        if (!MurasameEvolutionTracker.isValidBlade(stack)) {
            return;
        }
        stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            int kills = state.getKillCount();
            int souls = state.getProudSoulCount();
            if (kills >= REQUIRED_KILLS && souls >= REQUIRED_SOULS) {
                MurasameEvolutionTracker.evolveBlade(player, stack, state);
            }
        });
    }

    private static void evolveBlade(Player player, ItemStack stack, ISlashBladeState state) {
        ListTag se = new ListTag();
        se.add((Object)StringTag.m_129297_((String)"murasame:murasame_blessing"));
        state.setModel(new ResourceLocation("murasame", "models/murasame/murasamemaru_awakened.obj"));
        state.setTexture(new ResourceLocation("murasame", "models/murasame/murasamemaru_awakened.png"));
        state.setBaseAttackModifier(40.0f);
        state.setTranslationKey("item.murasame.murasamemaru_awakened");
        state.setSlashArtsKey(new ResourceLocation("murasame", "spatial_slash"));
        state.setSpecialEffects(se);
        stack.m_41663_(Enchantments.f_44977_, 15);
        stack.m_41663_(Enchantments.f_44981_, 3);
        stack.m_41663_(Enchantments.f_44986_, 10);
        stack.m_41663_(Enchantments.f_44988_, 10);
        stack.m_41663_(Enchantments.f_44978_, 25);
        stack.m_41714_((Component)Component.m_237115_((String)"item.murasame.murasamemaru_awakened"));
        stack.m_41784_().m_128379_(EVOLVED_TAG, true);
        Murasame.playSound(player, (SoundEvent)SoundRegistry.MURASAME_GREETING.get());
        player.m_5661_((Component)Component.m_237115_((String)"message.murasame.evolved"), true);
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12090_, SoundSource.PLAYERS, 0.5f, 1.2f);
    }

    public static boolean isValidBlade(ItemStack stack) {
        return stack.m_41720_() instanceof ItemSlashBlade && !MurasameEvolutionTracker.isEvolved(stack) && stack.getCapability(ItemSlashBlade.BLADESTATE).map(state -> "item.murasame.murasamemaru".equals(state.getTranslationKey())).orElse(false) != false;
    }

    private static boolean isEvolved(ItemStack stack) {
        return stack.m_41784_().m_128471_(EVOLVED_TAG);
    }
}

