/*
 * Decompiled with CFR 0.152.
 */
package cn.adwadg.murasame.events;

import cn.adwadg.murasame.Murasame;
import cn.adwadg.murasame.Registry.SoundRegistry;
import cn.adwadg.murasame.playerdata.PlayerSoulData;
import cn.adwadg.murasame.playerdata.PlayerSoulDataManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="murasame")
public class PlayerEventHandler {
    private static final Map<UUID, ItemStack> lastHeldBlades = new HashMap<UUID, ItemStack>();
    private static final Random random = new Random();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerEventHandler.checkWeaponSwitch(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            lastHeldBlades.put(player2.m_20148_(), ItemStack.f_41583_);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            lastHeldBlades.remove(player2.m_20148_());
        }
    }

    private static void checkWeaponSwitch(ServerPlayer player) {
        boolean isHolding;
        UUID playerId = player.m_20148_();
        ItemStack currentBlade = PlayerEventHandler.findAwakenedMurasame((Player)player);
        ItemStack lastBlade = lastHeldBlades.getOrDefault(playerId, ItemStack.f_41583_);
        boolean wasHolding = PlayerEventHandler.isAwakenedMurasame(lastBlade);
        if (wasHolding != (isHolding = PlayerEventHandler.isAwakenedMurasame(currentBlade))) {
            Vec3 lookVec = player.m_20154_().m_82541_();
            Vec3 rightVec = new Vec3(-lookVec.f_82481_, 0.0, lookVec.f_82479_).m_82541_();
            double x = player.m_20185_() + lookVec.f_82479_ * 3.5 - rightVec.f_82479_ * 2.3;
            double y = player.m_20186_() + (double)player.m_20192_() + 0.5 + lookVec.f_82480_ * 3.5;
            double z = player.m_20189_() + lookVec.f_82481_ * 3.5 - rightVec.f_82481_ * 2.3;
            PlayerSoulData playerData = PlayerSoulDataManager.getOrCreatePlayerData((Player)player);
            if (playerData.shouldShowMurasameSoul()) {
                PlayerEventHandler.spawnSpawnEffect((Level)player.m_284548_(), x, y, z);
            }
            SoundEvent[] SWITCH_SOUNDS = new SoundEvent[]{(SoundEvent)SoundRegistry.MURASAME_SWITCH.get(), (SoundEvent)SoundRegistry.MURASAME_SWITCH2.get(), (SoundEvent)SoundRegistry.MURASAME_SWITCH3.get(), (SoundEvent)SoundRegistry.MURASAME_SWITCH4.get(), (SoundEvent)SoundRegistry.MURASAME_SWITCH5.get(), (SoundEvent)SoundRegistry.MURASAME_SWITCH6.get(), (SoundEvent)SoundRegistry.MURASAME_SWITCH7.get(), (SoundEvent)SoundRegistry.MURASAME_SWITCH8.get(), (SoundEvent)SoundRegistry.MURASAME_SWITCH9.get()};
            SoundEvent sound = SWITCH_SOUNDS[random.nextInt(SWITCH_SOUNDS.length)];
            if (isHolding) {
                Murasame.playSound((Player)player, sound);
            }
            if (playerData.shouldShowMurasameSoul()) {
                Murasame.playSound((Player)player, SoundEvents.f_11871_);
            }
        }
        lastHeldBlades.put(playerId, currentBlade);
    }

    private static ItemStack findAwakenedMurasame(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.m_21120_(hand);
            if (!PlayerEventHandler.isAwakenedMurasame(stack)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private static boolean isAwakenedMurasame(ItemStack stack) {
        return stack.m_41720_() instanceof ItemSlashBlade && stack.getCapability(ItemSlashBlade.BLADESTATE).map(state -> "item.murasame.murasamemaru_awakened".equals(state.getTranslationKey())).orElse(false) != false;
    }

    public static void spawnSpawnEffect(Level world, double x, double y, double z) {
        if (!world.f_46443_) {
            for (int i = 0; i < 36; ++i) {
                double angle = Math.toRadians(i * 10);
                double speed = 0.4;
                double dx = Math.cos(angle) * speed;
                double dz = Math.sin(angle) * speed;
                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123759_, x, y, z, 4, dx, 0.05, dz, 0.1);
            }
        }
    }
}

