/*
 * Decompiled with CFR 0.152.
 */
package cn.adwadg.murasame.events;

import cn.adwadg.murasame.Entities.EntityMurasameSoul;
import cn.adwadg.murasame.Murasame;
import cn.adwadg.murasame.Registry.ModEntities;
import cn.adwadg.murasame.playerdata.PlayerSoulData;
import cn.adwadg.murasame.playerdata.PlayerSoulDataManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="murasame", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerSoulHandler {
    private static final Map<UUID, EntityMurasameSoul> soulMap = new HashMap<UUID, EntityMurasameSoul>();

    private static void spawnSoulEntity(Player player) {
        try {
            EntityMurasameSoul existing = soulMap.get(player.m_20148_());
            if (existing != null && existing.m_6084_()) {
                return;
            }
            PlayerSoulData playerData = PlayerSoulDataManager.getOrCreatePlayerData(player);
            if (!playerData.shouldShowMurasameSoul()) {
                return;
            }
            ServerLevel level = (ServerLevel)player.m_9236_();
            EntityMurasameSoul soul = new EntityMurasameSoul((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.MURASAME_SOUL.get()), (Level)level);
            float distance = 3.5f;
            float horizontalOffset = -2.3f;
            Vec3 position = null;
            if (player != null) {
                position = soul.calculateLeftFrontPosition(player, distance, horizontalOffset);
            }
            soul.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
            if (player != null) {
                soul.m_7618_(EntityAnchorArgument.Anchor.EYES, player.m_146892_());
            }
            soul.setOwner(player);
            if (level.m_7967_((Entity)soul)) {
                soulMap.put(player.m_20148_(), soul);
            }
        }
        catch (Exception e) {
            Murasame.LOGGER.error("\u751f\u6210\u5f02\u5e38", (Throwable)e);
        }
    }

    public static void removeSoul(Player player) {
        EntityMurasameSoul soul = soulMap.remove(player.m_20148_());
        if (soul != null && soul.m_6084_()) {
            Murasame.LOGGER.debug("removed player soul: {}", (Object)player.m_19879_());
            soul.m_146870_();
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        PlayerSoulHandler.removeSoul(player);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        PlayerSoulHandler.removeSoul(player);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        PlayerSoulData playerData = PlayerSoulDataManager.getOrCreatePlayerData(event.player);
        boolean showMurasameSoul = playerData.shouldShowMurasameSoul();
        if (event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.f_19797_ % 3 == 0) {
                ItemStack stack = player2.m_21120_(InteractionHand.MAIN_HAND);
                boolean shouldHave = false;
                if (stack.m_41720_() instanceof ItemSlashBlade && stack.getCapability(ItemSlashBlade.BLADESTATE).map(state -> "item.murasame.murasamemaru_awakened".equals(state.getTranslationKey())).orElse(false).booleanValue()) {
                    shouldHave = true;
                }
                EntityMurasameSoul soul = soulMap.get(player2.m_20148_());
                if (shouldHave && showMurasameSoul) {
                    if (soul == null || !soul.m_6084_()) {
                        PlayerSoulHandler.spawnSoulEntity((Player)player2);
                    }
                } else if (soul != null) {
                    PlayerSoulHandler.removeSoul((Player)player2);
                }
            }
        }
    }

    public static void updateSoulState(Player player) {
        PlayerSoulData playerData = PlayerSoulDataManager.getOrCreatePlayerData(player);
        boolean showMurasameSoul = playerData.shouldShowMurasameSoul();
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        boolean shouldHave = false;
        if (stack.m_41720_() instanceof ItemSlashBlade && stack.getCapability(ItemSlashBlade.BLADESTATE).map(state -> "item.murasame.murasamemaru_awakened".equals(state.getTranslationKey())).orElse(false).booleanValue()) {
            shouldHave = true;
        }
        EntityMurasameSoul soul = soulMap.get(player.m_20148_());
        if (shouldHave && showMurasameSoul) {
            if (soul == null || !soul.m_6084_()) {
                PlayerSoulHandler.spawnSoulEntity(player);
            }
        } else if (soul != null) {
            PlayerSoulHandler.removeSoul(player);
        }
    }
}

