/*
 * Decompiled with CFR 0.152.
 */
package cn.adwadg.murasame.events;

import cn.adwadg.murasame.Murasame;
import cn.adwadg.murasame.Registry.SoundRegistry;
import cn.adwadg.murasame.client.utils.MurasameEvolutionTracker;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="murasame", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SoundEventHandler {
    private static final Random random = new Random();
    private static final Map<UUID, Boolean> wasInCombat = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Integer> lowHpCooldown = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> frightenedCooldown = new HashMap<UUID, Integer>();
    private static final Map<UUID, Vec3> lastPlayerPositions = new HashMap<UUID, Vec3>();
    private static final Map<UUID, Integer> afkCooldowns = new HashMap<UUID, Integer>();

    private static boolean isHoldingAwakenedMurasame(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.m_21120_(hand);
            if (!(stack.m_41720_() instanceof ItemSlashBlade)) continue;
            return stack.getCapability(ItemSlashBlade.BLADESTATE).map(state -> "item.murasame.murasamemaru_awakened".equals(state.getTranslationKey())).orElse(false);
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
        Player player = event.getEntity();
        if (SoundEventHandler.isHoldingAwakenedMurasame(player)) {
            SoundEvent sound = random.nextBoolean() ? (SoundEvent)SoundRegistry.MURASAME_MORNING.get() : (SoundEvent)SoundRegistry.MURASAME_MORNING2.get();
            Murasame.playSound(player, sound);
        }
        if (!event.updateLevel()) {
            SoundEventHandler.checkHands(player);
        }
    }

    private static void checkHands(Player player) {
        SoundEventHandler.checkHand(player, InteractionHand.MAIN_HAND);
        SoundEventHandler.checkHand(player, InteractionHand.OFF_HAND);
    }

    private static void checkHand(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (MurasameEvolutionTracker.isValidBlade(stack)) {
            MurasameEvolutionTracker.checkEvolution(player, stack);
        }
    }

    @SubscribeEvent
    public static void onPlayerSleep(PlayerSleepInBedEvent event) {
        Player player = event.getEntity();
        Level level = player.m_9236_();
        long time = level.m_46468_() % 24000L;
        if (time >= 13000L && time < 23000L && event.getResultStatus() == null && SoundEventHandler.isHoldingAwakenedMurasame(player)) {
            Murasame.playSound(player, (SoundEvent)SoundRegistry.MURASAME_NIGHT.get());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        UUID playerId = player.m_20148_();
        if (SoundEventHandler.isHoldingAwakenedMurasame(player)) {
            int cooldown;
            boolean inCombat;
            if (player.m_21223_() < player.m_21233_() * 0.4f) {
                int cooldown2 = lowHpCooldown.getOrDefault(playerId, 0);
                if (cooldown2 <= 0) {
                    Murasame.playSound(player, (SoundEvent)SoundRegistry.MURASAME_LOWHP.get());
                    lowHpCooldown.put(playerId, 600);
                } else {
                    lowHpCooldown.put(playerId, cooldown2 - 1);
                }
            } else {
                lowHpCooldown.remove(playerId);
            }
            boolean bl = inCombat = player.m_21188_() != null && player.f_19797_ - player.m_21213_() < 100;
            if (player.m_21223_() < player.m_21233_() * 0.2f && wasInCombat.getOrDefault(playerId, false).booleanValue() && !inCombat && (cooldown = frightenedCooldown.getOrDefault(playerId, 0).intValue()) <= 0) {
                Murasame.playSound(player, (SoundEvent)SoundRegistry.MURASAME_FRIGHTENED.get());
                frightenedCooldown.put(playerId, 1200);
            }
            wasInCombat.put(playerId, inCombat);
        }
        SoundEventHandler.checkAfkState(player);
    }

    private static void checkAfkState(Player player) {
        Vec3 lastPos;
        if (!SoundEventHandler.isHoldingAwakenedMurasame(player)) {
            player.getPersistentData().m_128405_("MurasameAfkTicks", 0);
            return;
        }
        UUID playerId = player.m_20148_();
        Vec3 currentPos = player.m_20182_();
        if (!currentPos.equals((Object)(lastPos = lastPlayerPositions.get(playerId)))) {
            lastPlayerPositions.put(playerId, currentPos);
            player.getPersistentData().m_128405_("MurasameAfkTicks", 0);
            return;
        }
        int afkTicks = player.getPersistentData().m_128451_("MurasameAfkTicks") + 1;
        player.getPersistentData().m_128405_("MurasameAfkTicks", afkTicks);
        if (afkTicks >= 200 && afkCooldowns.getOrDefault(playerId, 0) <= 0) {
            SoundEvent sound = random.nextBoolean() ? (SoundEvent)SoundRegistry.MURASAME_AFK.get() : (SoundEvent)SoundRegistry.MURASAME_AFK2.get();
            Murasame.playSound(player, sound);
            afkCooldowns.put(playerId, 600);
            player.getPersistentData().m_128405_("MurasameAfkTicks", 0);
        }
        afkCooldowns.computeIfPresent(playerId, (k, v) -> v > 0 ? v - 1 : 0);
    }

    @SubscribeEvent
    public static void onItemToss(ItemTossEvent event) {
        Player player = event.getPlayer();
        ItemStack stack = event.getEntity().m_32055_();
        if (stack.m_41720_() instanceof ItemSlashBlade && stack.getCapability(ItemSlashBlade.BLADESTATE).map(state -> "item.murasame.murasamemaru_awakened".equals(state.getTranslationKey())).orElse(false).booleanValue()) {
            Murasame.playSound(player, (SoundEvent)SoundRegistry.MURASAME_DROP.get());
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Player player;
        Entity source = event.getSource().m_7639_();
        if (source instanceof Player && SoundEventHandler.isHoldingAwakenedMurasame(player = (Player)source) && event.getEntity().m_21233_() >= 300.0f) {
            Murasame.playSound(player, (SoundEvent)SoundRegistry.MURASAME_AFTER_BOSS.get());
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (SoundEventHandler.isHoldingAwakenedMurasame(player)) {
            Murasame.playSound(player, (SoundEvent)SoundRegistry.MURASAME_COMFORT.get());
        }
    }
}

