/*
 * Decompiled with CFR 0.152.
 */
package cn.adwadg.murasame.network;

import cn.adwadg.murasame.Entities.EntityMurasameSoul;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class SoulVisibilityPacket {
    private final int entityId;
    private final boolean visible;

    public SoulVisibilityPacket(int entityId, boolean visible) {
        this.entityId = entityId;
        this.visible = visible;
    }

    public SoulVisibilityPacket(EntityMurasameSoul soul, boolean visible) {
        this.entityId = soul.m_19879_();
        this.visible = visible;
    }

    public static void encode(SoulVisibilityPacket msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.entityId);
        buffer.writeBoolean(msg.visible);
    }

    public static SoulVisibilityPacket decode(FriendlyByteBuf buffer) {
        return new SoulVisibilityPacket(buffer.readInt(), buffer.readBoolean());
    }

    public static void handle(SoulVisibilityPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            if (Minecraft.m_91087_().f_91073_ != null && (entity = Minecraft.m_91087_().f_91073_.m_6815_(msg.entityId)) instanceof EntityMurasameSoul) {
                EntityMurasameSoul soul = (EntityMurasameSoul)entity;
                soul.setVisible(msg.visible);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

