/*
 * Decompiled with CFR 0.152.
 */
package cn.adwadg.murasame.playerdata;

import cn.adwadg.murasame.playerdata.PlayerSoulData;
import cn.adwadg.murasame.playerdata.PlayerSoulDataProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerSoulDataManager {
    private static final Map<UUID, PlayerSoulData> playerDataMap = new HashMap<UUID, PlayerSoulData>();
    public static final ResourceLocation PLAYER_SOUL_DATA_ID = new ResourceLocation("murasame", "player_soul_data");

    public static PlayerSoulData getOrCreatePlayerData(Player player) {
        return playerDataMap.computeIfAbsent(player.m_20148_(), uuid -> new PlayerSoulData());
    }

    public static PlayerSoulData getPlayerData(Player player) {
        return playerDataMap.get(player.m_20148_());
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Player> event) {
        PlayerSoulDataProvider provider = new PlayerSoulDataProvider();
        event.addCapability(PLAYER_SOUL_DATA_ID, (ICapabilityProvider)provider);
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player originalPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        PlayerSoulData originalData = playerDataMap.get(originalPlayer.m_20148_());
        if (originalData != null) {
            PlayerSoulData newData = PlayerSoulDataManager.getOrCreatePlayerData(newPlayer);
            newData.copyFrom(originalData);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerSoulDataManager.getOrCreatePlayerData(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
    }

    @SubscribeEvent
    public static void onPlayerSave(PlayerEvent.SaveToFile event) {
        Player player = event.getEntity();
        PlayerSoulData playerData = PlayerSoulDataManager.getPlayerData(player);
        if (playerData != null) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void onPlayerLoad(PlayerEvent.LoadFromFile event) {
        Player player = event.getEntity();
        PlayerSoulData playerData = PlayerSoulDataManager.getOrCreatePlayerData(player);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
            event.register(PlayerSoulData.class);
        }
    }
}

