/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fastgamemodeswitchmod.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.fastgamemodeswitchmod.Fgsm1171Mod;
import net.mcreator.fastgamemodeswitchmod.procedures.GUIOpenerOnKeyPressedProcedure;
import net.mcreator.fastgamemodeswitchmod.procedures.TimeDayProcedure;
import net.mcreator.fastgamemodeswitchmod.procedures.TimeMidNightProcedure;
import net.mcreator.fastgamemodeswitchmod.procedures.TimeMorningProcedure;
import net.mcreator.fastgamemodeswitchmod.procedures.TimeNightProcedure;
import net.mcreator.fastgamemodeswitchmod.world.inventory.TimeGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TimeGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public TimeGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public TimeGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(TimeGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(TimeGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            TimeGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = TimeGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            GUIOpenerOnKeyPressedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            TimeMorningProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            TimeDayProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            TimeNightProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            TimeMidNightProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        Fgsm1171Mod.addNetworkMessage(TimeGUIButtonMessage.class, TimeGUIButtonMessage::buffer, TimeGUIButtonMessage::new, TimeGUIButtonMessage::handler);
    }
}

