/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.apiimpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.api.IBlockDisplayOverride;
import net.danygames2014.whatsthis.api.IElementFactory;
import net.danygames2014.whatsthis.api.IEntityDisplayOverride;
import net.danygames2014.whatsthis.api.IProbeConfig;
import net.danygames2014.whatsthis.api.IProbeConfigProvider;
import net.danygames2014.whatsthis.api.IProbeInfoEntityProvider;
import net.danygames2014.whatsthis.api.IProbeInfoProvider;
import net.danygames2014.whatsthis.api.ITheOneProbe;
import net.danygames2014.whatsthis.apiimpl.ProbeInfo;
import net.danygames2014.whatsthis.apiimpl.elements.ElementEntity;
import net.danygames2014.whatsthis.apiimpl.elements.ElementHorizontal;
import net.danygames2014.whatsthis.apiimpl.elements.ElementIcon;
import net.danygames2014.whatsthis.apiimpl.elements.ElementItemLabel;
import net.danygames2014.whatsthis.apiimpl.elements.ElementItemStack;
import net.danygames2014.whatsthis.apiimpl.elements.ElementProgress;
import net.danygames2014.whatsthis.apiimpl.elements.ElementText;
import net.danygames2014.whatsthis.apiimpl.elements.ElementVertical;
import net.danygames2014.whatsthis.config.ConfigSetup;

public class TheOneProbeImp
implements ITheOneProbe {
    public static int ELEMENT_TEXT;
    public static int ELEMENT_ITEM;
    public static int ELEMENT_PROGRESS;
    public static int ELEMENT_HORIZONTAL;
    public static int ELEMENT_VERTICAL;
    public static int ELEMENT_ENTITY;
    public static int ELEMENT_ICON;
    public static int ELEMENT_ITEMLABEL;
    private List<IProbeConfigProvider> configProviders = new ArrayList<IProbeConfigProvider>();
    private List<IProbeInfoProvider> providers = new ArrayList<IProbeInfoProvider>();
    private List<IProbeInfoEntityProvider> entityProviders = new ArrayList<IProbeInfoEntityProvider>();
    private List<IBlockDisplayOverride> blockOverrides = new ArrayList<IBlockDisplayOverride>();
    private List<IEntityDisplayOverride> entityOverrides = new ArrayList<IEntityDisplayOverride>();
    private Map<Integer, IElementFactory> factories = new HashMap<Integer, IElementFactory>();
    private int lastId = 0;

    public static void registerElements() {
        ELEMENT_TEXT = WhatsThis.theOneProbeImp.registerElementFactory(ElementText::new);
        ELEMENT_ITEM = WhatsThis.theOneProbeImp.registerElementFactory(ElementItemStack::new);
        ELEMENT_PROGRESS = WhatsThis.theOneProbeImp.registerElementFactory(ElementProgress::new);
        ELEMENT_HORIZONTAL = WhatsThis.theOneProbeImp.registerElementFactory(ElementHorizontal::new);
        ELEMENT_VERTICAL = WhatsThis.theOneProbeImp.registerElementFactory(ElementVertical::new);
        ELEMENT_ENTITY = WhatsThis.theOneProbeImp.registerElementFactory(ElementEntity::new);
        ELEMENT_ICON = WhatsThis.theOneProbeImp.registerElementFactory(ElementIcon::new);
        ELEMENT_ITEMLABEL = WhatsThis.theOneProbeImp.registerElementFactory(ElementItemLabel::new);
    }

    private int findProvider(String id) {
        for (int i = 0; i < this.providers.size(); ++i) {
            if (!id.equals(this.providers.get(i).getID())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void registerProvider(IProbeInfoProvider provider) {
        int idx = this.findProvider(provider.getID());
        if (idx != -1) {
            this.providers.set(idx, provider);
        } else {
            this.providers.add(provider);
        }
    }

    private int findEntityProvider(String id) {
        for (int i = 0; i < this.entityProviders.size(); ++i) {
            if (!id.equals(this.entityProviders.get(i).getID())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void registerEntityProvider(IProbeInfoEntityProvider provider) {
        int idx = this.findEntityProvider(provider.getID());
        if (idx != -1) {
            this.entityProviders.set(idx, provider);
        } else {
            this.entityProviders.add(provider);
        }
    }

    @Override
    public IElementFactory getElementFactory(int id) {
        return this.factories.get(id);
    }

    public ProbeInfo create() {
        return new ProbeInfo();
    }

    public List<IProbeInfoProvider> getProviders() {
        return this.providers;
    }

    public List<IProbeInfoEntityProvider> getEntityProviders() {
        return this.entityProviders;
    }

    private IProbeInfoProvider getProviderByID(String id) {
        for (IProbeInfoProvider provider : this.providers) {
            if (!provider.getID().equals(id)) continue;
            return provider;
        }
        return null;
    }

    private IProbeInfoEntityProvider getEntityProviderByID(String id) {
        for (IProbeInfoEntityProvider provider : this.entityProviders) {
            if (!provider.getID().equals(id)) continue;
            return provider;
        }
        return null;
    }

    public void configureProviders(String[] sortedProviders, Set<String> excludedProviders) {
        ArrayList<IProbeInfoProvider> newProviders = new ArrayList<IProbeInfoProvider>();
        for (String id : sortedProviders) {
            IProbeInfoProvider provider;
            if (excludedProviders.contains(id) || (provider = this.getProviderByID(id)) == null) continue;
            newProviders.add(provider);
        }
        for (IProbeInfoProvider provider : this.providers) {
            if (newProviders.contains(provider) || excludedProviders.contains(provider.getID())) continue;
            newProviders.add(provider);
        }
        this.providers = newProviders;
    }

    public void configureEntityProviders(String[] sortedProviders, Set<String> excludedProviders) {
        ArrayList<IProbeInfoEntityProvider> newProviders = new ArrayList<IProbeInfoEntityProvider>();
        for (String id : sortedProviders) {
            IProbeInfoEntityProvider provider;
            if (excludedProviders.contains(id) || (provider = this.getEntityProviderByID(id)) == null) continue;
            newProviders.add(provider);
        }
        for (IProbeInfoEntityProvider provider : this.entityProviders) {
            if (newProviders.contains(provider) || excludedProviders.contains(provider.getID())) continue;
            newProviders.add(provider);
        }
        this.entityProviders = newProviders;
    }

    @Override
    public int registerElementFactory(IElementFactory factory) {
        this.factories.put(this.lastId, factory);
        int id = this.lastId++;
        return id;
    }

    @Override
    public IProbeConfig createProbeConfig() {
        return ConfigSetup.getProbeConfig();
    }

    @Override
    public void registerProbeConfigProvider(IProbeConfigProvider provider) {
        this.configProviders.add(provider);
    }

    public List<IProbeConfigProvider> getConfigProviders() {
        return this.configProviders;
    }

    @Override
    public void registerBlockDisplayOverride(IBlockDisplayOverride override) {
        this.blockOverrides.add(override);
    }

    public List<IBlockDisplayOverride> getBlockOverrides() {
        return this.blockOverrides;
    }

    @Override
    public void registerEntityDisplayOverride(IEntityDisplayOverride override) {
        this.entityOverrides.add(override);
    }

    public List<IEntityDisplayOverride> getEntityOverrides() {
        return this.entityOverrides;
    }
}

