/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.apiimpl.elements;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.danygames2014.whatsthis.api.IElement;
import net.danygames2014.whatsthis.api.IItemStyle;
import net.danygames2014.whatsthis.apiimpl.TheOneProbeImp;
import net.danygames2014.whatsthis.apiimpl.client.ElementItemStackRender;
import net.danygames2014.whatsthis.apiimpl.styles.ItemStyle;
import net.danygames2014.whatsthis.network.NetworkUtil;
import net.minecraft.class_31;

public class ElementItemStack
implements IElement {
    private final class_31 stack;
    private final IItemStyle style;

    public ElementItemStack(class_31 stack, IItemStyle style) {
        this.stack = stack;
        this.style = style;
    }

    public ElementItemStack(DataInputStream stream) throws IOException {
        this.stack = stream.readBoolean() ? NetworkUtil.readItemStack(stream) : null;
        this.style = new ItemStyle().width(stream.readInt()).height(stream.readInt());
    }

    @Override
    public void toBytes(DataOutputStream stream) throws IOException {
        if (this.stack != null) {
            stream.writeBoolean(true);
            NetworkUtil.writeItemStack(stream, this.stack);
        } else {
            stream.writeBoolean(false);
        }
        stream.writeInt(this.style.getWidth());
        stream.writeInt(this.style.getHeight());
    }

    @Override
    public void render(int x, int y) {
        ElementItemStackRender.render(this.stack, this.style, x, y);
    }

    @Override
    public int getWidth() {
        return this.style.getWidth();
    }

    @Override
    public int getHeight() {
        return this.style.getHeight();
    }

    @Override
    public int getID() {
        return TheOneProbeImp.ELEMENT_ITEM;
    }
}

