/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.apiimpl.elements;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import net.danygames2014.whatsthis.api.ElementAlignment;
import net.danygames2014.whatsthis.api.IElement;
import net.danygames2014.whatsthis.apiimpl.TheOneProbeImp;
import net.danygames2014.whatsthis.apiimpl.elements.AbstractElementPanel;

public class ElementVertical
extends AbstractElementPanel {
    public static final int SPACING = 2;

    public ElementVertical(Integer borderColor, int spacing, ElementAlignment alignment) {
        super(borderColor, spacing, alignment);
    }

    public ElementVertical(DataInputStream stream) {
        super(stream);
    }

    @Override
    public void toBytes(DataOutputStream stream) {
        super.toBytes(stream);
    }

    @Override
    public void render(int x, int y) {
        super.render(x, y);
        if (this.borderColor != null) {
            x += 3;
            y += 3;
        }
        int totWidth = this.getWidth();
        for (IElement element : this.children) {
            int w = element.getWidth();
            int cx = x;
            switch (this.alignment) {
                case ALIGN_TOPLEFT: {
                    break;
                }
                case ALIGN_CENTER: {
                    cx = x + (totWidth - w) / 2;
                    break;
                }
                case ALIGN_BOTTOMRIGHT: {
                    cx = x + totWidth - w;
                }
            }
            element.render(cx, y);
            y += element.getHeight() + this.spacing;
        }
    }

    private int getBorderSpacing() {
        return this.borderColor == null ? 0 : 6;
    }

    @Override
    public int getHeight() {
        int h = 0;
        for (IElement element : this.children) {
            h += element.getHeight();
        }
        return h + this.spacing * (this.children.size() - 1) + this.getBorderSpacing();
    }

    @Override
    public int getWidth() {
        int w = 0;
        for (IElement element : this.children) {
            int ww = element.getWidth();
            if (ww <= w) continue;
            w = ww;
        }
        return w + this.getBorderSpacing();
    }

    @Override
    public int getID() {
        return TheOneProbeImp.ELEMENT_VERTICAL;
    }
}

