/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.apiimpl.providers.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.danygames2014.whatsthis.api.ElementAlignment;
import net.danygames2014.whatsthis.api.IIconStyle;
import net.danygames2014.whatsthis.api.ILayoutStyle;
import net.danygames2014.whatsthis.api.IProbeInfo;
import net.danygames2014.whatsthis.api.TextStyleClass;
import net.danygames2014.whatsthis.config.Config;
import net.danygames2014.whatsthis.item.ProbeUtil;
import net.minecraft.class_124;
import net.minecraft.class_14;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_339;
import net.minecraft.class_352;
import net.minecraft.class_54;
import net.minecraft.class_632;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.item.tool.TagToolLevel;
import net.modificationstation.stationapi.api.item.tool.ToolLevel;
import net.modificationstation.stationapi.api.tag.TagKey;
import org.apache.commons.lang3.StringUtils;

public class HarvestabilityInfo {
    private static final String ICONS = "/assets/whatsthis/stationapi/textures/gui/icons.png";
    private static ArrayList<HarvestLevelEntry> HARVEST_LEVELS = null;
    private static final HashMap<BlockState, String> harvestLevelCache = new HashMap();
    private static final HashMap<BlockState, String> harvestToolCache = new HashMap();
    private static final HashMap<String, class_31> testTools = new HashMap();

    private static void getToolLevels() {
        if (HARVEST_LEVELS != null) {
            return;
        }
        HARVEST_LEVELS = new ArrayList();
        ToolLevel currentLevel = (ToolLevel)ToolLevel.ALL_LEVELS.toArray()[0];
        boolean run = true;
        while (run) {
            Set predecessors = ToolLevel.GRAPH.predecessors((Object)currentLevel);
            if (!predecessors.isEmpty()) {
                currentLevel = (ToolLevel)predecessors.toArray()[0];
                continue;
            }
            run = false;
        }
        run = true;
        while (run) {
            if (currentLevel instanceof TagToolLevel) {
                TagToolLevel tagToolLevel = (TagToolLevel)currentLevel;
                String name = tagToolLevel.tag.id().path;
                String[] split = tagToolLevel.tag.id().path.split("_");
                if (split.length > 0) {
                    name = split[split.length - 2];
                    name = StringUtils.capitalize((String)name);
                }
                HARVEST_LEVELS.add(new HarvestLevelEntry(name, (TagKey<class_17>)tagToolLevel.tag, (ToolLevel)tagToolLevel));
            } else {
                HARVEST_LEVELS.add(new HarvestLevelEntry(currentLevel.toString(), null, currentLevel));
            }
            Set successors = ToolLevel.GRAPH.successors((Object)currentLevel);
            if (!successors.isEmpty()) {
                currentLevel = (ToolLevel)successors.toArray()[0];
                continue;
            }
            run = false;
        }
    }

    private static String getHarvestLevel(BlockState state) {
        HarvestabilityInfo.getToolLevels();
        return harvestLevelCache.computeIfAbsent(state, HarvestabilityInfo::computeHarvestLevel);
    }

    private static String computeHarvestLevel(BlockState state) {
        for (HarvestLevelEntry entry : HARVEST_LEVELS) {
            if (!ToolLevel.isSuitable((ToolLevel)entry.toolLevel, (BlockState)state)) continue;
            return entry.name;
        }
        return "";
    }

    private static String getHarvestTool(class_18 world, class_339 pos, BlockState state, class_17 block) {
        if (!harvestToolCache.containsKey(state)) {
            harvestToolCache.put(state, HarvestabilityInfo.computeHarvestTools(world, pos, state, block));
        }
        return harvestToolCache.get(state);
    }

    private static String computeHarvestTools(class_18 world, class_339 pos, BlockState state, class_17 block) {
        String harvestTool = null;
        float blockHardness = state.getHardness((class_14)world, pos);
        if (blockHardness > 0.0f) {
            for (Map.Entry<String, class_31> testToolEntry : testTools.entrySet()) {
                class_31 testTool = testToolEntry.getValue();
                if (testTool == null) continue;
                class_124 class_1242 = testTool.method_694();
                if (class_1242 instanceof class_632) {
                    class_632 toolItem = (class_632)class_1242;
                    if (!(testTool.method_708(block) >= toolItem.field_2711.method_1418())) continue;
                    return testToolEntry.getKey();
                }
                if (!(testTool.method_694() instanceof class_352 ? testTool.method_708(block) > 1.5f : testTool.method_708(block) > 1.0f)) continue;
                return testToolEntry.getKey();
            }
        }
        return harvestTool;
    }

    static void showHarvestLevel(IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState state, class_17 block) {
        String harvestTool = HarvestabilityInfo.getHarvestTool(world, pos, state, block);
        String harvestLevel = HarvestabilityInfo.getHarvestLevel(state);
        if (harvestTool != null) {
            probeInfo.text(String.valueOf((Object)TextStyleClass.LABEL) + "Tool: " + String.valueOf((Object)TextStyleClass.INFO) + harvestTool + " (level " + harvestLevel + ")");
        }
    }

    private static Harvestable isHarvestable(class_54 player, class_18 world, class_339 pos, BlockState state, class_17 block) {
        if (block.method_1595() == -1.0f) {
            return Harvestable.UNBREAKABLE;
        }
        return player.canHarvest((class_14)world, pos, state) ? Harvestable.HARVESTABLE : Harvestable.NOT_HARVESTABLE;
    }

    static void showCanBeHarvested(IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState state, class_17 block, class_54 player) {
        if (ProbeUtil.isHandProbe(player.method_502())) {
            return;
        }
        boolean v = Config.CLIENT_CONFIG.harvestStyleVanilla;
        int offs = v ? 16 : 0;
        int dim = v ? 13 : 16;
        ILayoutStyle alignment = probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
        IIconStyle iconStyle = probeInfo.defaultIconStyle().width(v ? 18 : 20).height(v ? 14 : 16).textureWidth(32).textureHeight(32);
        IProbeInfo horizontal = probeInfo.horizontal(alignment);
        switch (HarvestabilityInfo.isHarvestable(player, world, pos, state, block)) {
            case HARVESTABLE: {
                horizontal.icon(ICONS, 0, offs, dim, dim, iconStyle).text(String.valueOf((Object)TextStyleClass.OK) + "Harvestable");
                break;
            }
            case NOT_HARVESTABLE: {
                horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text(String.valueOf((Object)TextStyleClass.WARNING) + "Not Harvestable");
                break;
            }
            case UNBREAKABLE: {
                horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text(String.valueOf((Object)TextStyleClass.WARNING) + "Unbreakable");
            }
        }
    }

    static void showHarvestInfo(IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState state, class_17 block, class_54 player) {
        String harvestTool = HarvestabilityInfo.getHarvestTool(world, pos, state, block);
        String harvestLevel = HarvestabilityInfo.getHarvestLevel(state);
        boolean v = Config.CLIENT_CONFIG.harvestStyleVanilla;
        int offs = v ? 16 : 0;
        int dim = v ? 13 : 16;
        ILayoutStyle alignment = probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
        IIconStyle iconStyle = probeInfo.defaultIconStyle().width(v ? 18 : 20).height(v ? 14 : 16).textureWidth(32).textureHeight(32);
        IProbeInfo horizontal = probeInfo.horizontal(alignment);
        String harvestToolString = HarvestabilityInfo.getHarvestToolString(harvestTool, world, pos, state, block, player);
        switch (HarvestabilityInfo.isHarvestable(player, world, pos, state, block)) {
            case HARVESTABLE: {
                horizontal.icon(ICONS, 0, offs, dim, dim, iconStyle).text(harvestToolString);
                break;
            }
            case NOT_HARVESTABLE: {
                if (harvestLevel == null || harvestLevel.isEmpty()) {
                    horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text(harvestToolString);
                    break;
                }
                horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text(harvestToolString + String.valueOf((Object)TextStyleClass.WARNING) + " (" + harvestLevel + " Level)");
                break;
            }
            case UNBREAKABLE: {
                horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text(String.valueOf((Object)TextStyleClass.WARNING) + "Unbreakable");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getHarvestToolString(String harvestTool, class_18 world, class_339 pos, BlockState state, class_17 block, class_54 player) {
        if (harvestTool == null) return String.valueOf((Object)TextStyleClass.OK) + "No Tool";
        if (player.method_502() == null) return String.valueOf((Object)TextStyleClass.WARNING) + harvestTool;
        class_124 hand = player.method_502().method_694();
        float multiplier = player.method_502().method_694().method_438(player.method_502(), block);
        if (hand instanceof class_632 && multiplier > 1.0f) {
            return String.valueOf((Object)TextStyleClass.OK) + harvestTool;
        }
        if (hand instanceof class_352 && multiplier <= 1.5f) {
            return String.valueOf((Object)TextStyleClass.WARNING) + harvestTool;
        }
        if (!(multiplier <= 1.0f)) return String.valueOf((Object)TextStyleClass.WARNING) + harvestTool;
        return String.valueOf((Object)TextStyleClass.WARNING) + harvestTool;
    }

    static {
        testTools.put("Shovel", new class_31(class_124.field_490));
        testTools.put("Axe", new class_31(class_124.field_376));
        testTools.put("Pickaxe", new class_31(class_124.field_491));
        testTools.put("Hoe", new class_31(class_124.field_390));
        testTools.put("Sword", new class_31(class_124.field_489));
        testTools.put("Shears", new class_31((class_124)class_124.field_458));
    }

    private record HarvestLevelEntry(String name, TagKey<class_17> tagKey, ToolLevel toolLevel) {
    }

    static enum Harvestable {
        HARVESTABLE,
        NOT_HARVESTABLE,
        UNBREAKABLE;

    }
}

