/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.apiimpl.providers.block;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.danygames2014.whatsthis.Util;
import net.danygames2014.whatsthis.api.ElementAlignment;
import net.danygames2014.whatsthis.api.IProbeConfig;
import net.danygames2014.whatsthis.api.IProbeHitData;
import net.danygames2014.whatsthis.api.IProbeInfo;
import net.danygames2014.whatsthis.api.ProbeMode;
import net.danygames2014.whatsthis.api.TextStyleClass;
import net.danygames2014.whatsthis.apiimpl.styles.ItemStyle;
import net.danygames2014.whatsthis.apiimpl.styles.LayoutStyle;
import net.danygames2014.whatsthis.config.Config;
import net.danygames2014.whatsthis.config.ConfigSetup;
import net.minecraft.class_124;
import net.minecraft.class_134;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_339;
import net.minecraft.class_55;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.registry.BlockRegistry;

public class InventoryInfo {
    static void showInventoryInfo(ProbeMode mode, IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState state, class_17 block, IProbeHitData data, IProbeConfig config) {
        IProbeConfig.ConfigMode chestMode = config.getShowChestContents();
        ArrayList<Object> stacks = null;
        if (!(chestMode != IProbeConfig.ConfigMode.EXTENDED || Config.PROBE_CONFIG.showSmallChestContentsWithoutSneaking <= 0 && ConfigSetup.getInventoriesToShow().isEmpty())) {
            int slots;
            if (ConfigSetup.getInventoriesToShow().contains(BlockRegistry.INSTANCE.getId((Object)block))) {
                chestMode = IProbeConfig.ConfigMode.NORMAL;
            } else if (Config.PROBE_CONFIG.showSmallChestContentsWithoutSneaking > 0 && (slots = InventoryInfo.getInventoryContents(world, pos, stacks = new ArrayList())) <= Config.PROBE_CONFIG.showSmallChestContentsWithoutSneaking) {
                chestMode = IProbeConfig.ConfigMode.NORMAL;
            }
        } else if (chestMode == IProbeConfig.ConfigMode.NORMAL && !ConfigSetup.getInventoriesToNotShow().isEmpty() && ConfigSetup.getInventoriesToNotShow().contains(BlockRegistry.INSTANCE.getId((Object)block))) {
            chestMode = IProbeConfig.ConfigMode.EXTENDED;
        }
        if (Util.show(mode, chestMode)) {
            if (stacks == null) {
                stacks = new ArrayList<class_31>();
                InventoryInfo.getInventoryContents(world, pos, stacks);
            }
            if (!stacks.isEmpty()) {
                boolean showDetailed = Util.show(mode, config.getShowChestContentsDetailed()) && stacks.size() <= Config.PROBE_CONFIG.showItemDetailThreshold;
                InventoryInfo.showInventoryContents(probeInfo, world, pos, stacks, showDetailed);
            }
        }
    }

    private static void showInventoryContents(IProbeInfo probeInfo, class_18 world, class_339 pos, List<class_31> stacks, boolean detailed) {
        IProbeInfo vertical = null;
        IProbeInfo horizontal = null;
        int rows = 0;
        int idx = 0;
        vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Config.parseColor(Config.CLIENT_CONFIG.chestContentsBorderColor)).spacing(0));
        if (detailed) {
            for (class_31 stackInSlot : stacks) {
                horizontal = vertical.horizontal(new LayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER));
                horizontal.item(stackInSlot, new ItemStyle().width(16).height(16)).text(String.valueOf((Object)TextStyleClass.INFO) + stackInSlot.method_694().method_469());
            }
        } else {
            for (class_31 stackInSlot : stacks) {
                if (idx % 10 == 0) {
                    horizontal = vertical.horizontal(new LayoutStyle().spacing(0));
                    if (++rows > 4) break;
                }
                horizontal.item(stackInSlot);
                ++idx;
            }
        }
    }

    private static int getInventoryContents(class_18 world, class_339 pos, List<class_31> stacks) {
        class_55 blockEntity = world.method_1777(pos.field_2100, pos.field_2101, pos.field_2102);
        HashSet<class_124> foundItems = Config.CLIENT_CONFIG.compactEqualStacks != false ? new HashSet<class_124>() : null;
        int inventorySize = 0;
        try {
            if (blockEntity instanceof class_134) {
                class_134 inventory = (class_134)blockEntity;
                inventorySize = inventory.method_948();
                for (int i = 0; i < inventorySize; ++i) {
                    InventoryInfo.addItemStack(stacks, foundItems, inventory.method_954(i));
                }
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Getting the contents of a " + String.valueOf(BlockRegistry.INSTANCE.getId((Object)world.getBlockState(pos).getBlock())) + " (" + blockEntity.getClass().getName() + ")", e);
        }
        return inventorySize;
    }

    private static void addItemStack(List<class_31> stacks, Set<class_124> foundItems, class_31 stack) {
        if (stack == null || stack.method_694() == null || stack.field_751 <= 0) {
            return;
        }
        if (foundItems != null && foundItems.contains(stack.method_694())) {
            for (class_31 s : stacks) {
                if (!s.method_702(stack)) continue;
                s.field_751 += stack.field_751;
                return;
            }
        }
        stacks.add(stack.method_724());
        if (foundItems != null) {
            foundItems.add(stack.method_694());
        }
    }
}

