/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.apiimpl.providers.entity;

import java.text.DecimalFormat;
import net.danygames2014.whatsthis.Util;
import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.api.ElementAlignment;
import net.danygames2014.whatsthis.api.IEntityDisplayOverride;
import net.danygames2014.whatsthis.api.IProbeConfig;
import net.danygames2014.whatsthis.api.IProbeHitEntityData;
import net.danygames2014.whatsthis.api.IProbeInfo;
import net.danygames2014.whatsthis.api.IProbeInfoEntityProvider;
import net.danygames2014.whatsthis.api.ProbeMode;
import net.danygames2014.whatsthis.api.TextStyleClass;
import net.danygames2014.whatsthis.apiimpl.ProbeConfig;
import net.danygames2014.whatsthis.config.ConfigSetup;
import net.minecraft.class_107;
import net.minecraft.class_121;
import net.minecraft.class_127;
import net.minecraft.class_18;
import net.minecraft.class_206;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_613;

public class DefaultProbeInfoEntityProvider
implements IProbeInfoEntityProvider {
    private static DecimalFormat dfCommas = new DecimalFormat("##.#");
    private static final String[] SHEEP_COLORS = new String[]{"White", "Orange", "Magenta", "Light Blue", "Yellow", "Lime", "Pink", "Gray", "Light Gray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};

    @Override
    public String getID() {
        return WhatsThis.NAMESPACE.id("entity_default").toString();
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, class_54 player, class_18 world, class_57 entity, IProbeHitEntityData data) {
        class_613 sheep;
        int sheepColor;
        ProbeConfig config = ConfigSetup.getProbeConfig();
        boolean handled = false;
        for (IEntityDisplayOverride override : WhatsThis.theOneProbeImp.getEntityOverrides()) {
            if (!override.overrideStandardInfo(mode, probeInfo, player, world, entity, data)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            DefaultProbeInfoEntityProvider.showStandardInfo(mode, probeInfo, entity, config);
        }
        if (entity instanceof class_127) {
            class_127 livingEntity = (class_127)entity;
            if (Util.show(mode, config.getShowMobHealth())) {
                int health = livingEntity.field_1036;
                int maxHealth = livingEntity.field_1009;
                probeInfo.progress(health, maxHealth, probeInfo.defaultProgressStyle().lifeBar(true).showText(false).width(150).height(10));
                if (mode == ProbeMode.EXTENDED) {
                    probeInfo.text(String.valueOf((Object)TextStyleClass.LABEL) + "Health: " + String.valueOf((Object)TextStyleClass.INFOIMP) + health + " / " + maxHealth);
                }
                if (entity instanceof class_54) {
                    int armor;
                    class_54 playerEntity = (class_54)entity;
                    if (playerEntity.field_519 != null && (armor = playerEntity.field_519.method_687()) > 0) {
                        probeInfo.progress(armor, armor, probeInfo.defaultProgressStyle().armorBar(true).showText(false).width(80).height(10));
                    }
                }
            }
        }
        if (entity instanceof class_107) {
            class_107 painting = (class_107)entity;
            probeInfo.text(String.valueOf((Object)TextStyleClass.LABEL) + "Variant: " + String.valueOf((Object)TextStyleClass.INFO) + painting.field_1388.field_666);
        }
        if (entity instanceof class_613 && (sheepColor = (sheep = (class_613)entity).method_2047()) + 1 <= SHEEP_COLORS.length) {
            probeInfo.text(String.valueOf((Object)TextStyleClass.LABEL) + "Wool Color: " + String.valueOf((Object)TextStyleClass.INFO) + SHEEP_COLORS[sheepColor]);
        }
        if (Util.show(mode, config.getAnimalOwnerSetting()) && entity instanceof class_121) {
            class_121 wolf = (class_121)entity;
            if (wolf.method_425()) {
                String ownerName = wolf.method_432();
                if (ownerName == null || ownerName.isEmpty()) {
                    probeInfo.text(String.valueOf((Object)TextStyleClass.WARNING) + "Unknown owner");
                } else {
                    probeInfo.text(String.valueOf((Object)TextStyleClass.LABEL) + "Owned by: " + String.valueOf((Object)TextStyleClass.INFO) + ownerName);
                }
            } else {
                probeInfo.text(String.valueOf((Object)TextStyleClass.LABEL) + "Tameable");
            }
        }
    }

    public static String ticksToElapsedTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }

    public static void showStandardInfo(ProbeMode mode, IProbeInfo probeInfo, class_57 entity, IProbeConfig config) {
        String modid = Util.getModName(entity);
        if (Util.show(mode, config.getShowModName())) {
            probeInfo.horizontal().entity(entity).vertical().text(String.valueOf((Object)TextStyleClass.NAME) + class_206.method_734((class_57)entity)).text(String.valueOf((Object)TextStyleClass.MODNAME) + modid);
        } else {
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).entity(entity).text(String.valueOf((Object)TextStyleClass.NAME) + class_206.method_734((class_57)entity));
        }
    }
}

