/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.network;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_187;
import net.minecraft.class_31;
import net.minecraft.class_8;

public class NetworkUtil {
    public static class_8 readNBT(DataInputStream stream) {
        return (class_8)class_187.method_628((DataInput)stream);
    }

    public static void writeNBT(DataOutputStream stream, class_8 nbt) {
        class_187.method_624((class_187)nbt, (DataOutput)stream);
    }

    public static class_31 readItemStack(DataInputStream stream) throws IOException {
        return new class_31((int)stream.readShort(), (int)stream.readShort(), (int)stream.readShort());
    }

    public static void writeItemStack(DataOutputStream stream, class_31 stack) throws IOException {
        stream.writeShort(stack.field_753);
        stream.writeShort(stack.field_751);
        stream.writeShort(stack.method_722());
    }

    public static String readString(DataInputStream dataIn) throws IOException {
        int s = dataIn.readInt();
        if (s == -1) {
            return null;
        }
        if (s == 0) {
            return "";
        }
        byte[] dst = new byte[s];
        dataIn.readFully(dst);
        return new String(dst);
    }

    public static void writeString(DataOutputStream dataOut, String str) throws IOException {
        if (str == null) {
            dataOut.writeInt(-1);
            return;
        }
        byte[] bytes = str.getBytes();
        dataOut.writeInt(bytes.length);
        if (bytes.length > 0) {
            dataOut.write(bytes);
        }
    }

    public static String readStringUTF8(DataInputStream dataIn) throws IOException {
        int s = dataIn.readInt();
        if (s == -1) {
            return null;
        }
        if (s == 0) {
            return "";
        }
        byte[] dst = new byte[s];
        dataIn.readFully(dst);
        return new String(dst, StandardCharsets.UTF_8);
    }

    public static void writeStringUTF8(DataOutputStream dataOut, String str) throws IOException {
        if (str == null) {
            dataOut.writeInt(-1);
            return;
        }
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        dataOut.writeInt(bytes.length);
        if (bytes.length > 0) {
            dataOut.write(bytes);
        }
    }
}

