/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.rendering;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.api.IElement;
import net.danygames2014.whatsthis.api.IOverlayStyle;
import net.danygames2014.whatsthis.api.IProbeConfig;
import net.danygames2014.whatsthis.api.ProbeMode;
import net.danygames2014.whatsthis.api.TextStyleClass;
import net.danygames2014.whatsthis.apiimpl.ProbeHitData;
import net.danygames2014.whatsthis.apiimpl.ProbeHitEntityData;
import net.danygames2014.whatsthis.apiimpl.ProbeInfo;
import net.danygames2014.whatsthis.apiimpl.elements.ElementProgress;
import net.danygames2014.whatsthis.apiimpl.elements.ElementText;
import net.danygames2014.whatsthis.apiimpl.providers.block.DefaultProbeInfoProvider;
import net.danygames2014.whatsthis.apiimpl.providers.entity.DefaultProbeInfoEntityProvider;
import net.danygames2014.whatsthis.apiimpl.styles.ProgressStyle;
import net.danygames2014.whatsthis.config.Config;
import net.danygames2014.whatsthis.config.ConfigSetup;
import net.danygames2014.whatsthis.network.PacketGetEntityInfo;
import net.danygames2014.whatsthis.network.PacketGetInfo;
import net.danygames2014.whatsthis.network.ThrowableIdentity;
import net.danygames2014.whatsthis.rendering.RenderHelper;
import net.minecraft.class_169;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_206;
import net.minecraft.class_212;
import net.minecraft.class_26;
import net.minecraft.class_27;
import net.minecraft.class_31;
import net.minecraft.class_339;
import net.minecraft.class_40;
import net.minecraft.class_504;
import net.minecraft.class_520;
import net.minecraft.class_54;
import net.minecraft.class_564;
import net.minecraft.class_57;
import net.minecraft.class_608;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.util.Formatting;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class OverlayRenderer {
    private static Map<Pair<Integer, class_339>, Pair<Long, ProbeInfo>> cachedInfo = new HashMap<Pair<Integer, class_339>, Pair<Long, ProbeInfo>>();
    private static Map<Integer, Pair<Long, ProbeInfo>> cachedEntityInfo = new HashMap<Integer, Pair<Long, ProbeInfo>>();
    private static long lastCleanupTime = 0L;
    private static Pair<Long, ProbeInfo> lastPair;
    private static long lastPairTime;
    private static long lastRenderedTime;

    public static void renderHUD(ProbeMode mode, float partialTicks) {
        float dist = Config.PROBE_CONFIG.probeDistance.floatValue();
        class_27 mouseOver = Minecraft.field_2791.field_2823;
        if (mouseOver != null && mouseOver.field_1983 == class_212.field_790) {
            GL11.glPushMatrix();
            double scale = Config.CLIENT_CONFIG.tooltipScale.floatValue();
            Minecraft minecraft = Minecraft.field_2791;
            class_564 screenScaler = new class_564(minecraft.field_2824, minecraft.field_2802, minecraft.field_2803);
            double sw = screenScaler.method_1857();
            double sh = screenScaler.method_1858();
            RenderHelper.setupOverlayRendering(sw * scale, sh * scale);
            OverlayRenderer.renderHUDEntity(mode, mouseOver, sw * scale, sh * scale);
            RenderHelper.setupOverlayRendering(sw, sh);
            GL11.glPopMatrix();
            OverlayRenderer.checkCleanup();
            return;
        }
        class_40 entity = Minecraft.field_2791.field_2806;
        class_26 start = entity.method_931(partialTicks);
        class_26 vec31 = entity.method_926(partialTicks);
        class_26 end = start.method_1301(vec31.field_1585 * (double)dist, vec31.field_1586 * (double)dist, vec31.field_1587 * (double)dist);
        mouseOver = entity.field_1596.method_161(start, end, Config.CLIENT_CONFIG.showLiquids.booleanValue());
        if (mouseOver == null) {
            return;
        }
        if (mouseOver.field_1983 == class_212.field_789) {
            GL11.glPushMatrix();
            double scale = Config.CLIENT_CONFIG.tooltipScale.floatValue();
            class_564 scaledresolution = new class_564(Minecraft.field_2791.field_2824, Minecraft.field_2791.field_2802, Minecraft.field_2791.field_2803);
            double sw = scaledresolution.method_1857();
            double sh = scaledresolution.method_1858();
            RenderHelper.setupOverlayRendering(sw * scale, sh * scale);
            OverlayRenderer.renderHUDBlock(mode, mouseOver, sw * scale, sh * scale);
            RenderHelper.setupOverlayRendering(sw, sh);
            GL11.glPopMatrix();
        }
        OverlayRenderer.checkCleanup();
    }

    private static void renderHUDBlock(ProbeMode mode, class_27 mouseOver, double sw, double sh) {
        int dimension;
        Pair key;
        Pair<Long, ProbeInfo> cacheEntry;
        class_339 blockPos = new class_339(mouseOver.field_1984, mouseOver.field_1985, mouseOver.field_1986);
        class_40 player = Minecraft.field_2791.field_2806;
        if (player.field_1596.method_234(blockPos.field_2100, blockPos.field_2101, blockPos.field_2102)) {
            return;
        }
        long time = System.currentTimeMillis();
        IElement damageElement = null;
        if (Config.CLIENT_CONFIG.showBreakProgress > 0) {
            float damage = 0.0f;
            class_504 class_5042 = Minecraft.field_2791.field_2801;
            if (class_5042 instanceof class_608) {
                class_608 multiplayerInteractionManager = (class_608)class_5042;
                damage = multiplayerInteractionManager.field_2611;
            } else {
                class_5042 = Minecraft.field_2791.field_2801;
                if (class_5042 instanceof class_520) {
                    class_520 singleplayerInteractionManager = (class_520)class_5042;
                    damage = singleplayerInteractionManager.field_2184;
                }
            }
            if (damage > 0.0f) {
                damageElement = Config.CLIENT_CONFIG.showBreakProgress == 2 ? new ElementText(String.valueOf(Formatting.RED) + "Progress " + (int)(damage * 100.0f) + "%") : new ElementProgress((long)(damage * 100.0f), 100L, new ProgressStyle().prefix("Progress ").suffix("%").width(85).borderColor(0).filledColor(0).filledColor(-6750208).alternateFilledColor(-11206656));
            }
        }
        if ((cacheEntry = cachedInfo.get(key = Pair.of((Object)(dimension = player.field_1596.field_216.field_2179), (Object)blockPos))) == null || cacheEntry.getValue() == null) {
            if (cacheEntry == null || time >= (Long)cacheEntry.getLeft()) {
                cachedInfo.put((Pair<Integer, class_339>)key, (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), null));
                OverlayRenderer.requestBlockInfo(mode, mouseOver, blockPos, (class_54)player);
            }
            if (lastPair != null && time < lastPairTime + (long)Config.PROBE_CONFIG.timeout.intValue()) {
                OverlayRenderer.renderElements((ProbeInfo)lastPair.getRight(), ConfigSetup.getDefaultOverlayStyle(), sw, sh, damageElement);
                lastRenderedTime = time;
            } else if (Config.PROBE_CONFIG.waitingForServerTimeout > 0 && lastRenderedTime != -1L && time > lastRenderedTime + (long)Config.PROBE_CONFIG.waitingForServerTimeout.intValue()) {
                ProbeInfo info = OverlayRenderer.getWaitingInfo(mode, mouseOver, blockPos, (class_54)player);
                OverlayRenderer.registerProbeInfo(dimension, blockPos, info);
                lastPair = Pair.of((Object)time, (Object)info);
                lastPairTime = time;
                OverlayRenderer.renderElements((ProbeInfo)lastPair.getRight(), ConfigSetup.getDefaultOverlayStyle(), sw, sh, damageElement);
                lastRenderedTime = time;
            }
        } else {
            if (time > (Long)cacheEntry.getLeft() + (long)Config.PROBE_CONFIG.timeout.intValue()) {
                cachedInfo.put((Pair<Integer, class_339>)key, (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), (Object)((ProbeInfo)cacheEntry.getRight())));
                OverlayRenderer.requestBlockInfo(mode, mouseOver, blockPos, (class_54)player);
            }
            OverlayRenderer.renderElements((ProbeInfo)cacheEntry.getRight(), ConfigSetup.getDefaultOverlayStyle(), sw, sh, damageElement);
            lastRenderedTime = time;
            lastPair = cacheEntry;
            lastPairTime = time;
        }
    }

    private static void renderHUDEntity(ProbeMode mode, class_27 mouseOver, double sw, double sh) {
        class_57 entity = mouseOver.field_1989;
        if (entity == null) {
            return;
        }
        String entityString = class_206.method_734((class_57)entity);
        if (entityString == null && !(entity instanceof class_54)) {
            return;
        }
        int entityId = entity.field_1591;
        class_40 player = Minecraft.field_2791.field_2806;
        long time = System.currentTimeMillis();
        Pair<Long, ProbeInfo> cacheEntry = cachedEntityInfo.get(entityId);
        if (cacheEntry == null || cacheEntry.getValue() == null) {
            if (cacheEntry == null || time >= (Long)cacheEntry.getLeft()) {
                cachedEntityInfo.put(entityId, (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), null));
                OverlayRenderer.requestEntityInfo(mode, mouseOver, entity, (class_54)player);
            }
            if (lastPair != null && time < lastPairTime + (long)Config.PROBE_CONFIG.timeout.intValue()) {
                OverlayRenderer.renderElements((ProbeInfo)lastPair.getRight(), ConfigSetup.getDefaultOverlayStyle(), sw, sh, null);
                lastRenderedTime = time;
            } else if (Config.PROBE_CONFIG.waitingForServerTimeout > 0 && lastRenderedTime != -1L && time > lastRenderedTime + (long)Config.PROBE_CONFIG.waitingForServerTimeout.intValue()) {
                ProbeInfo info = OverlayRenderer.getWaitingEntityInfo(mode, mouseOver, entity, (class_54)player);
                OverlayRenderer.registerProbeInfo(entityId, info);
                lastPair = Pair.of((Object)time, (Object)info);
                lastPairTime = time;
                OverlayRenderer.renderElements((ProbeInfo)lastPair.getRight(), ConfigSetup.getDefaultOverlayStyle(), sw, sh, null);
                lastRenderedTime = time;
            }
        } else {
            if (time > (Long)cacheEntry.getLeft() + (long)Config.PROBE_CONFIG.timeout.intValue()) {
                cachedEntityInfo.put(entityId, (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), (Object)((ProbeInfo)cacheEntry.getRight())));
                OverlayRenderer.requestEntityInfo(mode, mouseOver, entity, (class_54)player);
            }
            OverlayRenderer.renderElements((ProbeInfo)cacheEntry.getRight(), ConfigSetup.getDefaultOverlayStyle(), sw, sh, null);
            lastRenderedTime = time;
            lastPair = cacheEntry;
            lastPairTime = time;
        }
    }

    public static void renderElements(ProbeInfo probeInfo, IOverlayStyle style, double sw, double sh, @Nullable IElement extra) {
        if (extra != null) {
            probeInfo.element(extra);
        }
        GL11.glScalef((float)(1.0f / Config.CLIENT_CONFIG.tooltipScale.floatValue()), (float)(1.0f / Config.CLIENT_CONFIG.tooltipScale.floatValue()), (float)(1.0f / Config.CLIENT_CONFIG.tooltipScale.floatValue()));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.disableLighting();
        int scaledWidth = (int)sw;
        int scaledHeight = (int)sh;
        int probeWidth = probeInfo.getWidth();
        int probeHeight = probeInfo.getHeight();
        int offset = style.getBorderOffset();
        int thick = style.getBorderThickness();
        int margin = 0;
        if (thick > 0) {
            probeWidth += (offset + thick + 3) * 2;
            probeHeight += (offset + thick + 3) * 2;
            margin = offset + thick + 3;
        }
        int x = style.getLeftX() != -1 ? style.getLeftX() : (style.getRightX() != -1 ? scaledWidth - probeWidth - style.getRightX() : (scaledWidth - probeWidth) / 2);
        int y = style.getTopY() != -1 ? style.getTopY() : (style.getBottomY() != -1 ? scaledHeight - probeHeight - style.getBottomY() : (scaledHeight - probeHeight) / 2);
        if (thick > 0) {
            if (offset > 0) {
                RenderHelper.drawThickBeveledBox(x, y, x + probeWidth - 1, y + probeHeight - 1, thick, style.getBoxColor(), style.getBoxColor(), style.getBoxColor());
            }
            RenderHelper.drawThickBeveledBox(x + offset, y + offset, x + probeWidth - 1 - offset, y + probeHeight - 1 - offset, thick, style.getBorderColor(), style.getBorderColor(), style.getBoxColor());
        }
        if (!Minecraft.field_2791.field_2813) {
            RenderHelper.rot += 0.5f;
        }
        probeInfo.render(x + margin, y + margin);
        if (extra != null) {
            probeInfo.removeElement(extra);
        }
    }

    private static void requestBlockInfo(ProbeMode mode, class_27 mouseOver, class_339 pos, class_54 player) {
        class_18 world = player.field_1596;
        BlockState blockState = world.getBlockState(pos);
        class_31 pickBlock = new class_31(blockState.getBlock(), 1, world.method_1778(pos.field_2100, pos.field_2101, pos.field_2102));
        PacketHelper.send((class_169)new PacketGetInfo(world.field_216.field_2179, pos, mode, mouseOver, pickBlock));
    }

    private static void requestEntityInfo(ProbeMode mode, class_27 mouseOver, class_57 entity, class_54 player) {
        PacketHelper.send((class_169)new PacketGetEntityInfo(player.field_1596.field_216.field_2179, mode, mouseOver, entity));
    }

    public static void registerProbeInfo(int dim, class_339 pos, ProbeInfo probeInfo) {
        if (probeInfo == null) {
            return;
        }
        long time = System.currentTimeMillis();
        cachedInfo.put((Pair<Integer, class_339>)Pair.of((Object)dim, (Object)pos), (Pair<Long, ProbeInfo>)Pair.of((Object)time, (Object)probeInfo));
    }

    public static void registerProbeInfo(int entityId, ProbeInfo probeInfo) {
        if (probeInfo == null) {
            return;
        }
        long time = System.currentTimeMillis();
        cachedEntityInfo.put(entityId, (Pair<Long, ProbeInfo>)Pair.of((Object)time, (Object)probeInfo));
    }

    private static ProbeInfo getWaitingInfo(ProbeMode mode, class_27 mouseOver, class_339 pos, class_54 player) {
        ProbeInfo probeInfo = WhatsThis.theOneProbeImp.create();
        class_18 world = player.field_1596;
        BlockState state = world.getBlockState(pos);
        class_17 block = state.getBlock();
        class_31 pickBlock = new class_31(block, 1, world.method_1778(pos.field_2100, pos.field_2101, pos.field_2102));
        ProbeHitData data = new ProbeHitData(pos, class_26.method_1293((double)mouseOver.field_1984, (double)mouseOver.field_1985, (double)mouseOver.field_1986), Direction.byId((int)mouseOver.field_1987), pickBlock);
        IProbeConfig probeConfig = WhatsThis.theOneProbeImp.createProbeConfig();
        try {
            DefaultProbeInfoProvider.showStandardBlockInfo(mode, probeInfo, world, pos, state, block, player, data, probeConfig);
        }
        catch (Exception e) {
            ThrowableIdentity.registerThrowable(e);
            probeInfo.text(String.valueOf((Object)TextStyleClass.ERROR) + "Error (see log for details)!");
        }
        probeInfo.text(String.valueOf((Object)TextStyleClass.ERROR) + "Waiting for server...");
        return probeInfo;
    }

    private static ProbeInfo getWaitingEntityInfo(ProbeMode mode, class_27 mouseOver, class_57 entity, class_54 player) {
        ProbeInfo probeInfo = WhatsThis.theOneProbeImp.create();
        ProbeHitEntityData data = new ProbeHitEntityData(class_26.method_1293((double)mouseOver.field_1984, (double)mouseOver.field_1985, (double)mouseOver.field_1986));
        IProbeConfig probeConfig = WhatsThis.theOneProbeImp.createProbeConfig();
        try {
            DefaultProbeInfoEntityProvider.showStandardInfo(mode, probeInfo, entity, probeConfig);
        }
        catch (Exception e) {
            ThrowableIdentity.registerThrowable(e);
            probeInfo.text(String.valueOf((Object)TextStyleClass.ERROR) + "Error (see log for details)!");
        }
        probeInfo.text(String.valueOf((Object)TextStyleClass.ERROR) + "Waiting for server...");
        return probeInfo;
    }

    private static void checkCleanup() {
        long time = System.currentTimeMillis();
        if (time > lastCleanupTime + 5000L) {
            OverlayRenderer.cleanupCachedBlocks(time);
            OverlayRenderer.cleanupCachedEntities(time);
            lastCleanupTime = time;
        }
    }

    private static void cleanupCachedBlocks(long time) {
        HashMap<Pair<Integer, class_339>, Pair<Long, ProbeInfo>> newCachedInfo = new HashMap<Pair<Integer, class_339>, Pair<Long, ProbeInfo>>();
        for (Map.Entry<Pair<Integer, class_339>, Pair<Long, ProbeInfo>> entry : cachedInfo.entrySet()) {
            long t = (Long)entry.getValue().getLeft();
            if (time >= t + (long)Config.PROBE_CONFIG.timeout.intValue() + 1000L) continue;
            newCachedInfo.put(entry.getKey(), entry.getValue());
        }
        cachedInfo = newCachedInfo;
    }

    private static void cleanupCachedEntities(long time) {
        HashMap<Integer, Pair<Long, ProbeInfo>> newCachedInfo = new HashMap<Integer, Pair<Long, ProbeInfo>>();
        for (Map.Entry<Integer, Pair<Long, ProbeInfo>> entry : cachedEntityInfo.entrySet()) {
            long t = (Long)entry.getValue().getLeft();
            if (time >= t + (long)Config.PROBE_CONFIG.timeout.intValue() + 1000L) continue;
            newCachedInfo.put(entry.getKey(), entry.getValue());
        }
        cachedEntityInfo = newCachedInfo;
    }

    static {
        lastPairTime = 0L;
        lastRenderedTime = -1L;
    }
}

