/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.rendering;

import java.awt.Color;
import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.rendering.ProbeTextRenderer;
import net.minecraft.class_31;
import net.minecraft.class_57;
import net.minecraft.class_578;
import net.minecraft.class_583;
import net.minecraft.class_67;
import net.minecraft.class_92;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;

public class RenderHelper {
    public static float rot = 0.0f;

    public static void enableLighting() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2896);
    }

    public static void enableItemLighting() {
        RenderHelper.enableLighting();
        GL11.glEnable((int)32826);
        GL11.glPushMatrix();
        GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        class_583.method_1930();
        GL11.glPopMatrix();
    }

    public static void disableLighting() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
    }

    public static void disableItemLighting() {
        RenderHelper.disableLighting();
        GL11.glDisable((int)32826);
        class_583.method_1927();
    }

    public static void enableStandardItemLighting() {
        class_583.method_1930();
    }

    public static void disableStandardItemLighting() {
        class_583.method_1927();
    }

    public static void renderEntity(class_57 entity, int xPos, int yPos, float scale) {
        GL11.glPushMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(xPos + 8), (float)(yPos + 32), (float)50.0f);
        GL11.glScalef((float)(-scale), (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.enableStandardItemLighting();
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        entity.field_1607 = 0.0f;
        GL11.glTranslatef((float)0.0f, (float)entity.method_1378(), (float)0.0f);
        class_578.field_2489.field_2498 = 180.0f;
        try {
            class_578.field_2489.method_1920(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        }
        catch (Exception e) {
            WhatsThis.LOGGER.error("Error rendering entity!", (Throwable)e);
        }
        GL11.glPopMatrix();
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
        GL11.glEnable((int)2929);
        GL11.glDisable((int)2903);
        GL13.glActiveTexture((int)33985);
        GL11.glDisable((int)3553);
        GL13.glActiveTexture((int)33984);
    }

    public static boolean renderItemStackWithCount(Minecraft mc, class_92 itemRender, class_31 stack, int xo, int yo, boolean highlight) {
        if (stack.field_751 <= 1) {
            return RenderHelper.renderItemStack(mc, itemRender, stack, xo, yo, "", highlight);
        }
        return RenderHelper.renderItemStack(mc, itemRender, stack, xo, yo, "" + stack.field_751, highlight);
    }

    public static boolean renderItemStack(Minecraft minecraft, class_92 itemRenderer, class_31 stack, int x, int y, String txt, boolean highlight) {
        if (stack == null || stack.method_694() == null) {
            return false;
        }
        if (highlight) {
            GL11.glDisable((int)2896);
            RenderHelper.drawVerticalGradientRect(x, y, x + 16, y + 16, -2130706433, -1);
        }
        RenderHelper.enableItemLighting();
        itemRenderer.method_1487(minecraft.field_2815, minecraft.field_2814, stack, x, y);
        itemRenderer.method_1488(minecraft.field_2815, minecraft.field_2814, stack, x, y);
        RenderHelper.disableItemLighting();
        GL11.glEnable((int)3042);
        return true;
    }

    public static boolean renderItemStack(Minecraft minecraft, class_92 itemRenderer, class_31 stack, int x, int y, String txt) {
        return RenderHelper.renderItemStack(minecraft, itemRenderer, stack, x, y, txt, false);
    }

    public static void drawVerticalGradientRect(int startX, int startY, int endX, int endY, int startColor, int endColor) {
        float zLevel = 0.0f;
        float startColorA = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startColorR = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startColorG = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startColorB = (float)(startColor & 0xFF) / 255.0f;
        float endColorA = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endColorR = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endColorG = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endColorB = (float)(endColor & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)6406);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        class_67 tessellator = class_67.field_2054;
        tessellator.method_1695();
        tessellator.method_1690(startColorR, startColorG, startColorB, startColorA);
        tessellator.method_1687((double)endX, (double)startY, (double)zLevel);
        tessellator.method_1687((double)startX, (double)startY, (double)zLevel);
        tessellator.method_1690(endColorR, endColorG, endColorB, endColorA);
        tessellator.method_1687((double)startX, (double)endY, (double)zLevel);
        tessellator.method_1687((double)endX, (double)endY, (double)zLevel);
        tessellator.method_1685();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)6406);
        GL11.glEnable((int)3553);
    }

    public static void drawHorizontalGradientRect(int x1, int y1, int x2, int y2, int color1, int color2) {
    }

    public static void drawHorizontalLine(int x1, int y1, int x2, int color) {
        RenderHelper.fill(x1, y1, x2, y1 + 1, color);
    }

    public static void drawVerticalLine(int x1, int y1, int y2, int color) {
        RenderHelper.fill(x1, y1, x1 + 1, y2, color);
    }

    public static void drawLeftTriangle(int x, int y, int color) {
        RenderHelper.drawVerticalLine(x, y, y, color);
        RenderHelper.drawVerticalLine(x + 1, y - 1, y + 1, color);
        RenderHelper.drawVerticalLine(x + 2, y - 2, y + 2, color);
    }

    public static void drawRightTriangle(int x, int y, int color) {
        RenderHelper.drawVerticalLine(x, y, y, color);
        RenderHelper.drawVerticalLine(x - 1, y - 1, y + 1, color);
        RenderHelper.drawVerticalLine(x - 2, y - 2, y + 2, color);
    }

    public static void drawUpTriangle(int x, int y, int color) {
        RenderHelper.drawHorizontalLine(x, y, x, color);
        RenderHelper.drawHorizontalLine(x - 1, y + 1, x + 1, color);
        RenderHelper.drawHorizontalLine(x - 2, y + 2, x + 2, color);
    }

    public static void drawDownTriangle(int x, int y, int color) {
        RenderHelper.drawHorizontalLine(x, y, x, color);
        RenderHelper.drawHorizontalLine(x - 1, y - 1, x + 1, color);
        RenderHelper.drawHorizontalLine(x - 2, y - 2, x + 2, color);
    }

    public static void drawFlatButtonBox(int x1, int y1, int x2, int y2, int bright, int average, int dark) {
        RenderHelper.drawBeveledBox(x1, y1, x2, y2, bright, dark, average);
    }

    public static void drawFlatButtonBoxGradient(int x1, int y1, int x2, int y2, int bright, int average1, int average2, int dark) {
        RenderHelper.drawVerticalGradientRect(x1 + 1, y1 + 1, x2 - 1, y2 - 1, average2, average1);
        RenderHelper.drawHorizontalLine(x1, y1, x2 - 1, bright);
        RenderHelper.drawVerticalLine(x1, y1, y2 - 1, bright);
        RenderHelper.drawVerticalLine(x2 - 1, y1, y2 - 1, dark);
        RenderHelper.drawHorizontalLine(x1, y2 - 1, x2, dark);
    }

    public static void drawBeveledBox(int x1, int y1, int x2, int y2, int topleftcolor, int botrightcolor, int fillcolor) {
        if (fillcolor != -1) {
            RenderHelper.fill(x1 + 1, y1 + 1, x2 - 1, y2 - 1, fillcolor);
        }
        RenderHelper.drawHorizontalLine(x1, y1, x2 - 1, topleftcolor);
        RenderHelper.drawVerticalLine(x1, y1, y2 - 1, topleftcolor);
        RenderHelper.drawVerticalLine(x2 - 1, y1, y2 - 1, botrightcolor);
        RenderHelper.drawHorizontalLine(x1, y2 - 1, x2, botrightcolor);
    }

    public static void drawThickBeveledBox(int x1, int y1, int x2, int y2, int thickness, int topleftcolor, int botrightcolor, int fillcolor) {
        if (fillcolor != -1) {
            RenderHelper.fill(x1 + 1, y1 + 1, x2 - 1, y2 - 1, fillcolor);
        }
        RenderHelper.fill(x1, y1, x2 - 1, y1 + thickness, topleftcolor);
        RenderHelper.fill(x1, y1, x1 + thickness, y2 - 1, topleftcolor);
        RenderHelper.fill(x2 - thickness, y1, x2, y2 - 1, botrightcolor);
        RenderHelper.fill(x1, y2 - thickness, x2, y2, botrightcolor);
    }

    public static void fill(int x1, int y1, int x2, int y2, int color) {
        int var6;
        if (x1 < x2) {
            var6 = x1;
            x1 = x2;
            x2 = var6;
        }
        if (y1 < y2) {
            var6 = y1;
            y1 = y2;
            y2 = var6;
        }
        float var11 = (float)(color >> 24 & 0xFF) / 255.0f;
        float var7 = (float)(color >> 16 & 0xFF) / 255.0f;
        float var8 = (float)(color >> 8 & 0xFF) / 255.0f;
        float var9 = (float)(color & 0xFF) / 255.0f;
        class_67 var10 = class_67.field_2054;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)var7, (float)var8, (float)var9, (float)var11);
        var10.method_1695();
        var10.method_1687((double)x1, (double)y2, 0.0);
        var10.method_1687((double)x2, (double)y2, 0.0);
        var10.method_1687((double)x2, (double)y1, 0.0);
        var10.method_1687((double)x1, (double)y1, 0.0);
        var10.method_1685();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, int twidth, int theight) {
        float zLevel = 0.01f;
        float xScale = 1.0f / (float)twidth;
        float yScale = 1.0f / (float)theight;
        class_67 t = class_67.field_2054;
        t.method_1695();
        t.method_1688((double)x, (double)(y + height), (double)zLevel, (double)((float)u * xScale), (double)((float)(v + height) * yScale));
        t.method_1688((double)(x + width), (double)(y + height), (double)zLevel, (double)((float)(u + width) * xScale), (double)((float)(v + height) * yScale));
        t.method_1688((double)(x + width), (double)y, (double)zLevel, (double)((float)(u + width) * xScale), (double)((float)v * yScale));
        t.method_1688((double)x, (double)y, (double)zLevel, (double)((float)u * xScale), (double)((float)v * yScale));
        t.method_1685();
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        float zLevel = 0.01f;
        float xScale = 0.00390625f;
        float yScale = 0.00390625f;
        class_67 t = class_67.field_2054;
        t.method_1695();
        t.method_1688((double)x, (double)(y + height), (double)zLevel, (double)((float)u * xScale), (double)((float)(v + height) * yScale));
        t.method_1688((double)(x + width), (double)(y + height), (double)zLevel, (double)((float)(u + width) * xScale), (double)((float)(v + height) * yScale));
        t.method_1688((double)(x + width), (double)y, (double)zLevel, (double)((float)(u + width) * xScale), (double)((float)v * yScale));
        t.method_1688((double)x, (double)y, (double)zLevel, (double)((float)u * xScale), (double)((float)v * yScale));
        t.method_1685();
    }

    public static int renderText(Minecraft minecraft, int x, int y, String text) {
        int width = ProbeTextRenderer.INSTANCE.method_1901(text);
        GL11.glDisable((int)3042);
        RenderHelper.renderStringAtPos(text, x + 1, y + 1, Color.WHITE, true);
        RenderHelper.renderStringAtPos(text, x, y, Color.WHITE, false);
        GL11.glEnable((int)3042);
        return width;
    }

    public static void renderStringAtPos(String text, int x, int y, Color color, boolean shadow) {
        int intColor = color.getRGB();
        if (shadow) {
            int shadowOffset = intColor & 0xFF000000;
            intColor = (intColor & 0xFCFCFC) >> 2;
            intColor += shadowOffset;
        }
        float red = (float)(intColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(intColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(intColor & 0xFF) / 255.0f;
        float alpha = (float)(intColor >> 24 & 0xFF) / 255.0f;
        if (alpha == 0.0f) {
            alpha = 1.0f;
        }
        ProbeTextRenderer.INSTANCE.renderStringAtPos(text, x, y, new Color(red, green, blue, alpha), shadow);
    }

    public static void setupOverlayRendering(double sw, double sh) {
        GL11.glClear((int)256);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sw, (double)sh, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }
}

