/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.blockgameprofiles.client;

import dev.bnjc.blockgameprofiles.BlockgameProfiles;
import dev.bnjc.blockgameprofiles.gamefeature.GameFeature;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.StatProfileGameFeature;
import dev.bnjc.blockgameprofiles.storage.Storage;
import java.util.ArrayList;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class BlockgameProfilesClient
implements ClientModInitializer {
    private static final ArrayList<GameFeature> loadedGameFeatures = new ArrayList();
    private static int errors;
    private static final int maxErrorsBeforeCrash = 5;

    public void onInitializeClient() {
        this.loadGameFeatures();
        Storage.setup();
    }

    private void loadGameFeatures() {
        BlockgameProfiles.LOGGER.info("[Blockgame Profiles] Loading game features...");
        this.loadGameFeature(new StatProfileGameFeature());
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            client.method_16011().method_15396("tickGameFeatures");
            for (GameFeature gameFeature : loadedGameFeatures) {
                block4: {
                    client.method_16011().method_15396(gameFeature.getClass().getSimpleName());
                    try {
                        gameFeature.tick(client);
                    }
                    catch (Exception e) {
                        if (errors > 5) {
                            throw e;
                        }
                        class_746 player = client.field_1724;
                        if (player == null) break block4;
                        player.method_7353(class_2561.method_30163((String)"\u00a74\u00a7l=== PLEASE REPORT THIS AS A BUG ==="), false);
                        player.method_7353(class_2561.method_30163((String)String.format("\u00a7cAn error occurred in %s!", gameFeature.getClass().getSimpleName())), false);
                        player.method_7353(class_2561.method_30163((String)(e.getClass().getName() + ": \u00a77" + e.getMessage())), false);
                        player.method_7353(class_2561.method_30163((String)"\u00a74\u00a7l================================="), false);
                        ++errors;
                    }
                }
                client.method_16011().method_15407();
            }
            client.method_16011().method_15407();
        });
    }

    private void loadGameFeature(GameFeature gameFeature) {
        if (!gameFeature.isEnabled()) {
            BlockgameProfiles.LOGGER.info("Skipping load of {} because it's disabled", (Object)gameFeature.getClass().getSimpleName().replace("GameFeature", " game feature"));
            return;
        }
        String featureName = gameFeature.getClass().getSimpleName().replace("GameFeature", " game feature");
        BlockgameProfiles.LOGGER.info("Loading {}", (Object)featureName);
        try {
            gameFeature.init(class_310.method_1551(), this);
            loadedGameFeatures.add(gameFeature);
        }
        catch (Exception e) {
            BlockgameProfiles.LOGGER.error("Failed to load {} game feature: {}", (Object)featureName, (Object)e.getMessage());
        }
    }

    public static ArrayList<GameFeature> getLoadedGameFeatures() {
        return loadedGameFeatures;
    }

    public static int getErrors() {
        return errors;
    }

    public static void setErrors(int errors) {
        BlockgameProfilesClient.errors = errors;
    }

    public static int getMaxErrorsBeforeCrash() {
        return 5;
    }
}

