/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.blockgameprofiles.gamefeature.statprofiles;

import dev.bnjc.blockgameprofiles.BlockgameProfiles;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.StatProfileGameFeature;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.allocate.StatAllocator;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.attribute.PlayerAttribute;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.gui.screen.StatScreen;
import dev.bnjc.blockgameprofiles.helper.NbtHelper;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_2499;
import net.minecraft.class_2649;
import net.minecraft.class_3917;
import net.minecraft.class_3944;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public final class StatScreenManager {
    private final StatProfileGameFeature gameFeature;
    private final StatAllocator statAllocator;
    @Nullable
    private StatScreen screen;
    private int syncId;
    private boolean dirtySyncId;
    @Nullable
    private List<class_1799> receivedInventory;
    private boolean shouldParsePoints;
    private State state;

    public StatScreenManager(StatProfileGameFeature gameFeature) {
        this.gameFeature = gameFeature;
        this.statAllocator = new StatAllocator(this);
        this.statAllocator.setOnAttributesChanged(() -> {
            if (this.screen != null) {
                this.screen.onAttributesChanged();
            }
        });
        this.screen = null;
        this.syncId = -1;
        this.dirtySyncId = true;
        this.receivedInventory = null;
        this.shouldParsePoints = false;
        this.state = State.IDLE;
    }

    public void openScreen(class_3944 packet) {
        class_746 player;
        if (this.screen != null) {
            this.shouldParsePoints = true;
        }
        if ((player = this.gameFeature.getMinecraftClient().field_1724) != null) {
            class_1707 screenHandler = (class_1707)class_3917.field_17327.method_17434(packet.method_17592(), player.method_31548());
            this.screen = new StatScreen(packet.method_17594(), this);
            player.field_7512 = screenHandler;
            this.gameFeature.getMinecraftClient().method_1507((class_437)this.screen);
        }
        this.statAllocator.onScreenRecreate();
        this.setSyncId(packet.method_17592());
    }

    public void receiveInventory(class_2649 packet) {
        this.receivedInventory = packet.method_11441();
        HashMap<String, PlayerAttribute> attributes = new HashMap<String, PlayerAttribute>();
        for (int slot = 0; slot < this.receivedInventory.size() && slot < 54; ++slot) {
            class_1799 itemStack = this.receivedInventory.get(slot);
            BlockgameProfiles.LOGGER.info("[Blockgame Profiles] Received item: {}", (Object)itemStack.method_7964().getString());
            if (itemStack.method_7964().getString().equals("Reallocate Attributes")) {
                this.statAllocator.setReallocationSlot(slot);
                if (this.screen != null) {
                    this.screen.onReallocationSlotSet();
                }
                this.parseReallocationItem(itemStack);
                continue;
            }
            PlayerAttribute attribute = PlayerAttribute.fromItem(itemStack, slot);
            if (attribute == null) continue;
            int finalSlot = slot;
            attributes.compute(attribute.getName(), (key, value) -> {
                if (value == null) {
                    return attribute;
                }
                value.getSlots().add(finalSlot);
                return value;
            });
            if (this.statAllocator.getAvailablePoints() != -1 && !this.shouldParsePoints) continue;
            this.statAllocator.setAvailablePoints(PlayerAttribute.getAvailablePoints(itemStack));
            this.shouldParsePoints = false;
        }
        this.statAllocator.setAttributes(attributes);
    }

    public void onScreenClose() {
        this.screen = null;
        this.statAllocator.stop();
        BlockgameProfiles.LOGGER.info("[Blockgame Profiles] Screen closed");
    }

    public void invalidateScreen() {
        this.dirtySyncId = true;
    }

    public void setSyncId(int syncId) {
        this.syncId = syncId;
        this.dirtySyncId = false;
        if (this.state == State.WAITING_FOR_SYNC_ID) {
            this.changeState(State.IDLE);
            this.statAllocator.nextStep();
        }
    }

    public boolean waitingForScreen() {
        return this.dirtySyncId || this.syncId == -1 || this.screen == null;
    }

    public void changeState(State state) {
        this.state = state;
    }

    private void parseReallocationItem(class_1799 stack) {
        class_2499 loreList = NbtHelper.getLore(stack);
        if (loreList == null) {
            BlockgameProfiles.LOGGER.warn("No lore found for reallocation item");
            return;
        }
        for (int i = 0; i < loreList.size(); ++i) {
            class_5250 text = NbtHelper.parseLore(loreList, i);
            if (text == null) continue;
            String lore = text.getString();
            Pattern pattern = Pattern.compile("You have spent a total of (\\d+) attributes\\.");
            Matcher matcher = pattern.matcher(lore);
            if (!matcher.matches()) continue;
            this.statAllocator.setSpentPoints(Integer.parseInt(matcher.group(1)));
            return;
        }
    }

    public StatProfileGameFeature getGameFeature() {
        return this.gameFeature;
    }

    public StatAllocator getStatAllocator() {
        return this.statAllocator;
    }

    @Nullable
    public StatScreen getScreen() {
        return this.screen;
    }

    public int getSyncId() {
        return this.syncId;
    }

    public boolean isDirtySyncId() {
        return this.dirtySyncId;
    }

    @Nullable
    public List<class_1799> getReceivedInventory() {
        return this.receivedInventory;
    }

    public boolean isShouldParsePoints() {
        return this.shouldParsePoints;
    }

    public State getState() {
        return this.state;
    }

    public void setDirtySyncId(boolean dirtySyncId) {
        this.dirtySyncId = dirtySyncId;
    }

    public static enum State {
        IDLE,
        WAITING_FOR_RESET,
        WAITING_FOR_ALLOCATION,
        WAITING_FOR_SYNC_ID,
        WAITING_FOR_INVENTORY,
        CAPACITY_EXCEEDED,
        FAILED;

    }
}

