/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.blockgameprofiles.gamefeature.statprofiles.allocate;

import dev.bnjc.blockgameprofiles.BlockgameProfiles;
import dev.bnjc.blockgameprofiles.event.chat.ReceiveChatMessageEvent;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.StatScreenManager;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.allocate.Command;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.allocate.StatProfile;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.attribute.PlayerAttribute;
import dev.bnjc.blockgameprofiles.helper.SoundHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_310;
import net.minecraft.class_636;
import org.jetbrains.annotations.Nullable;

public class StatAllocator {
    private final StatScreenManager screenManager;
    private int reallocationSlot = -1;
    private int availablePoints;
    private int spentPoints;
    private int previewSpentPoints;
    private int previewTotalPoints;
    @Nullable
    private Map<String, PlayerAttribute> attributes;
    @Nullable
    private Map<String, PlayerAttribute> previewAttributes;
    private boolean preview;
    @Nullable
    private Iterator<Command> commandIterator;
    @Nullable
    private Runnable onAttributesChanged;

    public StatAllocator(StatScreenManager screenManager) {
        this.screenManager = screenManager;
        this.attributes = null;
        this.availablePoints = -1;
        this.spentPoints = -1;
        this.commandIterator = null;
        this.preview = false;
        this.previewAttributes = null;
        this.previewSpentPoints = -1;
        this.previewTotalPoints = -1;
        ReceiveChatMessageEvent.EVENT.register(this::handleReceiveChatMessage);
    }

    public boolean allocate(@Nullable StatProfile profile) {
        if (profile == null || this.isAllocating()) {
            return false;
        }
        StatProfile tempProfile = new StatProfile("temp");
        tempProfile.fromAttributes(this.attributes == null ? new HashMap() : this.attributes);
        this.commandIterator = profile.buildCommands(tempProfile);
        this.nextStep();
        return true;
    }

    public void onScreenRecreate() {
        this.attributes = null;
    }

    public void nextStep() {
        if (this.commandIterator == null || !this.commandIterator.hasNext()) {
            this.stop();
            return;
        }
        if (this.missingRequirements()) {
            return;
        }
        Command command = this.commandIterator.next();
        if (command.isReset()) {
            this.resetStats();
        } else if (command.isIncrement()) {
            PlayerAttribute attribute = this.attributes.get(command.attrName());
            if (attribute == null) {
                BlockgameProfiles.LOGGER.warn("Attribute not found: {}", (Object)command.attrName());
                this.nextStep();
            } else {
                this.incrementStat(attribute);
            }
        } else {
            BlockgameProfiles.LOGGER.warn("Unknown command: {}", (Object)command);
            this.nextStep();
        }
    }

    public void resetStats() {
        StatScreenManager.State state = this.screenManager.getState();
        if (state != StatScreenManager.State.IDLE && state != StatScreenManager.State.CAPACITY_EXCEEDED) {
            BlockgameProfiles.LOGGER.warn("Cannot reset stats while in state: {}", (Object)state);
            return;
        }
        if (this.screenManager.waitingForScreen()) {
            BlockgameProfiles.LOGGER.warn("Waiting for screen. Cannot reset stats.");
            this.stop(StatScreenManager.State.FAILED);
            return;
        }
        if (this.reallocationSlot == -1) {
            BlockgameProfiles.LOGGER.warn("Reallocation slot is not set. Cannot reset stats.");
            this.stop(StatScreenManager.State.FAILED);
            return;
        }
        if (this.preview) {
            this.previewResetStats();
            return;
        }
        class_636 interactionManager = class_310.method_1551().field_1761;
        if (interactionManager == null) {
            BlockgameProfiles.LOGGER.warn("Interaction manager is not available. Cannot reset stats.");
            this.stop(StatScreenManager.State.FAILED);
            return;
        }
        this.screenManager.changeState(StatScreenManager.State.WAITING_FOR_RESET);
        this.screenManager.invalidateScreen();
        interactionManager.method_2906(this.screenManager.getSyncId(), this.reallocationSlot, 0, class_1713.field_7790, (class_1657)class_310.method_1551().field_1724);
    }

    private void previewResetStats() {
        this.setSpentPoints(0);
        SoundHelper.playItemPickupSound();
        if (this.previewAttributes != null) {
            for (Map.Entry<String, PlayerAttribute> entry : this.previewAttributes.entrySet()) {
                entry.setValue(entry.getValue().reset());
            }
        }
        this.notifyAttributesChanged();
    }

    public void incrementStat(PlayerAttribute attribute) {
        this.adjustStat(attribute, attribute.getCost());
    }

    public void decrementStat(PlayerAttribute attribute) {
        this.adjustStat(attribute, -attribute.getCost());
    }

    private void adjustStat(PlayerAttribute attribute, int amount) {
        if (this.screenManager.getState() != StatScreenManager.State.IDLE) {
            BlockgameProfiles.LOGGER.warn("Cannot increment stat while in state: {}", (Object)this.screenManager.getState());
            return;
        }
        if (this.screenManager.waitingForScreen()) {
            BlockgameProfiles.LOGGER.warn("Waiting for screen. Cannot increment stat.");
            this.stop(StatScreenManager.State.FAILED);
            return;
        }
        if (this.preview) {
            this.previewStatChange(attribute, amount);
            return;
        }
        class_636 interactionManager = class_310.method_1551().field_1761;
        if (interactionManager == null) {
            BlockgameProfiles.LOGGER.warn("Interaction manager is not available. Cannot increment stat.");
            this.stop(StatScreenManager.State.FAILED);
            return;
        }
        this.screenManager.changeState(StatScreenManager.State.WAITING_FOR_ALLOCATION);
        this.screenManager.invalidateScreen();
        interactionManager.method_2906(this.screenManager.getSyncId(), attribute.getFirstSlot(), 0, class_1713.field_7790, (class_1657)class_310.method_1551().field_1724);
    }

    private void previewStatChange(PlayerAttribute attribute, int amount) {
        if (this.getSpentPoints() + amount > this.getTotalPoints() || this.getSpentPoints() + amount < 0) {
            BlockgameProfiles.LOGGER.warn("Cannot change attribute: {}", (Object)attribute.getName());
            SoundHelper.playVillagerNoSound();
            return;
        }
        PlayerAttribute previewAttribute = attribute.adjust(amount);
        if (previewAttribute == attribute) {
            BlockgameProfiles.LOGGER.warn("Failed to adjust attribute: {}", (Object)attribute.getName());
            SoundHelper.playVillagerNoSound();
            return;
        }
        if (this.previewAttributes == null) {
            this.previewAttributes = new HashMap<String, PlayerAttribute>();
        }
        this.setSpentPoints(this.getSpentPoints() + amount);
        SoundHelper.playItemPickupSound();
        this.previewAttributes.put(attribute.getName(), previewAttribute);
        this.notifyAttributesChanged();
    }

    public void stop() {
        this.stop(StatScreenManager.State.IDLE);
    }

    private void stop(StatScreenManager.State state) {
        this.commandIterator = null;
        this.screenManager.changeState(state);
    }

    @Nullable
    public Map<String, PlayerAttribute> getAttributes() {
        return this.preview ? this.previewAttributes : this.attributes;
    }

    public void setAttributes(Map<String, PlayerAttribute> attributes) {
        this.attributes = attributes;
        this.notifyAttributesChanged();
        if (this.screenManager.getState() == StatScreenManager.State.WAITING_FOR_INVENTORY) {
            this.screenManager.changeState(StatScreenManager.State.IDLE);
            this.nextStep();
        }
    }

    public int getSpentPoints() {
        return this.preview ? this.previewSpentPoints : this.spentPoints;
    }

    public void setSpentPoints(int spentPoints) {
        if (this.preview) {
            this.previewSpentPoints = spentPoints;
        } else {
            this.spentPoints = spentPoints;
        }
    }

    public int getAvailablePoints() {
        if (this.preview) {
            return this.previewTotalPoints - this.previewSpentPoints;
        }
        return this.availablePoints;
    }

    public void setPreview(boolean preview) {
        this.setPreview(preview, null);
    }

    public void setPreview(boolean preview, @Nullable StatProfile profile) {
        this.preview = preview;
        if (this.preview) {
            this.previewAttributes = new HashMap<String, PlayerAttribute>();
            if (this.attributes != null) {
                for (Map.Entry<String, PlayerAttribute> entry : this.attributes.entrySet()) {
                    PlayerAttribute attribute = entry.getValue().copy();
                    if (profile != null) {
                        Integer spent = profile.getAttributeAllocations().get(entry.getKey());
                        attribute = spent != null ? attribute.withSpent(spent) : attribute.reset();
                    }
                    this.previewAttributes.put(entry.getKey(), attribute);
                }
            }
            this.previewTotalPoints = this.availablePoints + this.spentPoints;
            this.previewSpentPoints = Math.min(profile == null ? this.spentPoints : profile.getSpentPoints(), this.previewTotalPoints);
        } else {
            this.previewAttributes = null;
            this.previewSpentPoints = -1;
            this.previewTotalPoints = -1;
        }
        this.notifyAttributesChanged();
    }

    public boolean isAllocating() {
        return this.commandIterator != null;
    }

    public int getTotalPoints() {
        if (this.preview) {
            return this.previewTotalPoints;
        }
        if (this.availablePoints == -1 || this.getSpentPoints() == -1) {
            return -1;
        }
        return this.availablePoints + this.getSpentPoints();
    }

    private void notifyAttributesChanged() {
        if (this.onAttributesChanged != null) {
            this.onAttributesChanged.run();
        }
    }

    private boolean missingRequirements() {
        return !this.checkSyncId() || !this.checkInventory();
    }

    private boolean checkSyncId() {
        if (this.screenManager.isDirtySyncId() || this.screenManager.getSyncId() == -1) {
            this.screenManager.changeState(StatScreenManager.State.WAITING_FOR_SYNC_ID);
            return false;
        }
        return true;
    }

    private boolean checkInventory() {
        if (this.reallocationSlot == -1 || this.attributes == null) {
            this.screenManager.changeState(StatScreenManager.State.WAITING_FOR_INVENTORY);
            return false;
        }
        return true;
    }

    private class_1269 handleReceiveChatMessage(class_310 client, String message) {
        StatScreenManager.State state = this.screenManager.getState();
        if (state == StatScreenManager.State.WAITING_FOR_RESET && message.contains("You successfully reset your attributes")) {
            this.nextStep();
            return class_1269.field_21466;
        }
        if (state == StatScreenManager.State.WAITING_FOR_ALLOCATION) {
            if (message.contains("You successfully leveled up your")) {
                this.nextStep();
                return class_1269.field_21466;
            }
            if (message.contains("You do not have 1 attribute point")) {
                this.stop(StatScreenManager.State.CAPACITY_EXCEEDED);
                this.screenManager.setDirtySyncId(false);
                return class_1269.field_21466;
            }
        }
        return class_1269.field_5811;
    }

    public void setReallocationSlot(int reallocationSlot) {
        this.reallocationSlot = reallocationSlot;
    }

    public void setAvailablePoints(int availablePoints) {
        this.availablePoints = availablePoints;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setOnAttributesChanged(@Nullable Runnable onAttributesChanged) {
        this.onAttributesChanged = onAttributesChanged;
    }
}

