/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.blockgameprofiles.gamefeature.statprofiles.allocate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.allocate.Command;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.attribute.PlayerAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class StatProfile {
    public static final Codec<StatProfile> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(profile -> profile.name), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT).xmap(HashMap::new, Function.identity()).fieldOf("attributeAllocations").forGetter(profile -> profile.attributeAllocations), (App)Codec.INT.optionalFieldOf("order", (Object)0).forGetter(profile -> profile.order)).apply((Applicative)instance, (name, attributeAllocations, order) -> {
        StatProfile profile = new StatProfile((String)name, (int)order);
        profile.attributeAllocations.putAll((Map<String, Integer>)attributeAllocations);
        return profile;
    }));
    private final String name;
    private final HashMap<String, Integer> attributeAllocations;
    private final int order;

    public StatProfile(String name) {
        this(name, 0);
    }

    public StatProfile(String name, int order) {
        this.name = name;
        this.order = order;
        this.attributeAllocations = new HashMap();
    }

    public void fromAttributes(Map<String, PlayerAttribute> attributes) {
        this.reset();
        for (Map.Entry<String, PlayerAttribute> entry : attributes.entrySet()) {
            int spent = entry.getValue().getSpent();
            if (spent <= 0) continue;
            this.attributeAllocations.put(entry.getKey(), spent);
        }
    }

    public Iterator<Command> buildCommands(@Nullable StatProfile currentProfile) {
        boolean shouldReset;
        ArrayList<Command> commands = new ArrayList<Command>();
        Map<String, Integer> profileDiff = this.diffProfile(currentProfile);
        boolean bl = shouldReset = currentProfile == null || profileDiff.values().stream().anyMatch(i -> i < 0);
        if (shouldReset) {
            commands.add(Command.reset());
        }
        for (Map.Entry<String, Integer> entry : this.attributeAllocations.entrySet()) {
            int goal = entry.getValue();
            if (!shouldReset) {
                goal = profileDiff.getOrDefault(entry.getKey(), 0);
            }
            for (int i2 = 0; i2 < goal; ++i2) {
                commands.add(Command.increment(entry.getKey()));
            }
        }
        return commands.iterator();
    }

    public void reset() {
        this.attributeAllocations.clear();
    }

    public int getSpentPoints() {
        return this.attributeAllocations.values().stream().mapToInt(Integer::intValue).sum();
    }

    public boolean matches(@Nullable Map<String, PlayerAttribute> attributes) {
        if (attributes == null) {
            return false;
        }
        for (Map.Entry<String, PlayerAttribute> entry : attributes.entrySet()) {
            int goal;
            int spent = entry.getValue().getSpent();
            if (spent == (goal = this.attributeAllocations.getOrDefault(entry.getKey(), 0).intValue())) continue;
            return false;
        }
        return true;
    }

    public static StatProfile of(String name, Map<String, PlayerAttribute> attributes) {
        StatProfile profile = new StatProfile(name);
        profile.fromAttributes(attributes);
        return profile;
    }

    private Map<String, Integer> diffProfile(@Nullable StatProfile other) {
        HashMap<String, Integer> diff = new HashMap<String, Integer>();
        if (other == null) {
            return this.attributeAllocations;
        }
        HashSet<String> combinedKeys = new HashSet<String>(this.attributeAllocations.keySet());
        combinedKeys.addAll(other.attributeAllocations.keySet());
        for (String key : combinedKeys) {
            int otherSpent;
            int spent = this.attributeAllocations.getOrDefault(key, 0);
            if (spent == (otherSpent = other.attributeAllocations.getOrDefault(key, 0).intValue())) continue;
            diff.put(key, spent - otherSpent);
        }
        return diff;
    }

    public String getName() {
        return this.name;
    }

    public HashMap<String, Integer> getAttributeAllocations() {
        return this.attributeAllocations;
    }

    public int getOrder() {
        return this.order;
    }
}

