/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.blockgameprofiles.gamefeature.statprofiles.attribute;

import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.attribute.AttributeCategory;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.modifier.StatModifier;
import dev.bnjc.blockgameprofiles.helper.NbtHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class PlayerAttribute {
    private static final Pattern POINTS_PATTERN = Pattern.compile("Points Spent: (\\d+)/(\\d+)");
    private static final Pattern COST_PATTERN = Pattern.compile("Click to level up for (\\d+) attribute point.*");
    private static final Pattern CURRENT_POINTS_PATTERN = Pattern.compile(".*Current Attribute Points: (\\d+)");
    private final String name;
    private final int max;
    private final int spent;
    private final Set<StatModifier> buffs;
    private final int cost;
    private final HashSet<Integer> slots;
    private final class_1799 itemStack;
    private final AttributeCategory category;

    public PlayerAttribute(String name, int max, int spent, Set<StatModifier> buffs, int cost, int slot, class_1799 itemStack) {
        this(name, max, spent, buffs, cost, new HashSet<Integer>(List.of(Integer.valueOf(slot))), itemStack);
    }

    public PlayerAttribute(String name, int max, int spent, Set<StatModifier> buffs, int cost, HashSet<Integer> slots, class_1799 itemStack) {
        this.name = name;
        this.max = max;
        this.spent = spent;
        this.buffs = buffs;
        this.cost = cost;
        this.slots = slots;
        this.itemStack = itemStack;
        this.category = this.determineCategory(name);
    }

    public PlayerAttribute reset() {
        return this.withSpent(0);
    }

    public PlayerAttribute adjust(int spentAmount) {
        if (this.spent + spentAmount < 0 || this.spent + spentAmount > this.max) {
            return this;
        }
        return new PlayerAttribute(this.name, this.max, this.spent + spentAmount, this.buffs, this.cost, this.slots, this.itemStack);
    }

    public PlayerAttribute withSpent(int spent) {
        return new PlayerAttribute(this.name, this.max, spent, this.buffs, this.cost, this.slots, this.itemStack);
    }

    public int getFirstSlot() {
        return this.slots.stream().findFirst().orElse(-1);
    }

    public void fixLoreText() {
        ArrayList<class_5250> loreList = new ArrayList<class_5250>();
        loreList.add(class_2561.method_43470((String)""));
        loreList.add(class_2561.method_43470((String)"Points Spent: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)("" + this.spent)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)("" + this.max)).method_27692(class_124.field_1065)));
        loreList.add(class_2561.method_43470((String)""));
        loreList.add(class_2561.method_43470((String)"When Leveled Up:").method_27692(class_124.field_1063));
        for (StatModifier buff : this.buffs) {
            loreList.add(buff.toLore(this.spent));
        }
        loreList.add(class_2561.method_43470((String)""));
        loreList.add(class_2561.method_43470((String)("Left-click to level up by  " + this.cost + ".")).method_27692(class_124.field_1054));
        loreList.add(class_2561.method_43470((String)("Right-click to level down by " + this.cost + ".")).method_27692(class_124.field_1054));
        for (class_5250 lore : loreList) {
            lore.method_27694(style -> style.method_10978(Boolean.valueOf(false)));
        }
        this.itemStack.method_7911("display").method_10566("Lore", (class_2520)NbtHelper.buildLore(loreList));
    }

    public int getBarStep(float barWidth) {
        return Math.round((float)this.spent * barWidth / (float)this.max);
    }

    @Nullable
    public static PlayerAttribute fromItem(class_1799 stack, int slot) {
        if (stack == null || stack.method_7909() == class_1802.field_8162) {
            return null;
        }
        class_2499 loreList = NbtHelper.getLore(stack);
        if (loreList == null) {
            return null;
        }
        String name = stack.method_7964().getString();
        if ("Profile".equals(name)) {
            return null;
        }
        int max = -1;
        int spent = -1;
        int cost = -1;
        HashSet<StatModifier> buffs = new HashSet<StatModifier>();
        boolean inBuffs = false;
        for (int i = 0; i < loreList.size(); ++i) {
            StatModifier buff;
            class_5250 loreText = NbtHelper.parseLore(loreList, i);
            if (loreText == null) continue;
            String loreString = loreText.getString();
            if (loreString.isEmpty()) {
                inBuffs = false;
                continue;
            }
            Matcher matcher = POINTS_PATTERN.matcher(loreString);
            if (matcher.matches()) {
                spent = Integer.parseInt(matcher.group(1));
                max = Integer.parseInt(matcher.group(2));
                continue;
            }
            if (loreString.startsWith("When Leveled Up:")) {
                inBuffs = true;
                continue;
            }
            if (inBuffs && (buff = StatModifier.fromLore(loreString)) != null) {
                buffs.add(buff);
                continue;
            }
            matcher = COST_PATTERN.matcher(loreString);
            if (!matcher.matches()) continue;
            cost = Integer.parseInt(matcher.group(1));
        }
        return new PlayerAttribute(name, max, spent, buffs, cost, slot, stack);
    }

    public static int getAvailablePoints(class_1799 stack) {
        class_2499 loreList = NbtHelper.getLore(stack);
        if (loreList == null) {
            return -1;
        }
        for (int i = loreList.size() - 1; i >= 0; --i) {
            String loreString;
            Matcher matcher;
            class_5250 loreText = NbtHelper.parseLore(loreList, i);
            if (loreText == null || !(matcher = CURRENT_POINTS_PATTERN.matcher(loreString = loreText.getString())).matches()) continue;
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    private AttributeCategory determineCategory(String name) {
        return switch (name) {
            case "Ferocity", "Spartan", "Dexterity", "Alacrity", "Intelligence", "Precision", "Glass Cannon", "Bravery", "Bullying", "Assassin" -> AttributeCategory.OFFENSE;
            case "Wisdom", "Pacifist", "Volition", "Somatics", "Bloom", "Time Lord", "Beef Cake", "Chunky Soup" -> AttributeCategory.SUPPORT;
            case "Tenacity", "Shield Mastery", "Fortress", "Juggernaut", "Battleship", "Dreadnought" -> AttributeCategory.DEFENSE;
            default -> AttributeCategory.OTHER;
        };
    }

    public PlayerAttribute copy() {
        return new PlayerAttribute(this.name, this.max, this.spent, new HashSet<StatModifier>(this.buffs), this.cost, new HashSet<Integer>(this.slots), this.itemStack.method_7972());
    }

    public String getName() {
        return this.name;
    }

    public int getMax() {
        return this.max;
    }

    public int getSpent() {
        return this.spent;
    }

    public Set<StatModifier> getBuffs() {
        return this.buffs;
    }

    public int getCost() {
        return this.cost;
    }

    public HashSet<Integer> getSlots() {
        return this.slots;
    }

    public class_1799 getItemStack() {
        return this.itemStack;
    }

    public AttributeCategory getCategory() {
        return this.category;
    }
}

