/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.blockgameprofiles.gamefeature.statprofiles.gui.screen;

import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.StatScreenManager;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.allocate.StatProfile;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.attribute.PlayerAttribute;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.gui.widget.ModifierListWidget;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.gui.widget.StatGridWidget;
import dev.bnjc.blockgameprofiles.helper.GUIHelper;
import dev.bnjc.blockgameprofiles.storage.BlockgameData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;

public class StatScreen
extends class_437 {
    private static final class_2960 BACKGROUND_SPRITE = GUIHelper.sprite("background");
    private static final int BUTTON_SIZE = 14;
    private static final int MENU_WIDTH = 176;
    private static final int MENU_HEIGHT = 172;
    private static final int TITLE_LEFT = 8;
    private static final int TITLE_TOP = 8;
    private final StatScreenManager screenManager;
    private int left = 0;
    private int top = 0;
    @Nullable
    private PlayerAttribute hoveredAttribute;
    @Nullable
    private StatProfile previewingProfile;
    private StatGridWidget statGridWidget;
    private ModifierListWidget modifierListWidget;
    private class_342 profileNameField;
    private class_344 reallocateButton;
    private class_344 addProfileButton;
    private class_344 cancelPreviewButton;
    private class_344 saveProfileButton;
    private class_344 deleteProfileButton;
    private Map<String, class_344> profileButtons;
    private boolean isEditing = false;

    public StatScreen(class_2561 title, StatScreenManager screenManager) {
        super(title);
        this.screenManager = screenManager;
        this.hoveredAttribute = null;
        this.previewingProfile = null;
        if (!this.screenManager.getStatAllocator().isAllocating()) {
            this.screenManager.changeState(StatScreenManager.State.IDLE);
        }
    }

    protected void method_25426() {
        this.left = (this.field_22789 - this.getMenuWidth()) / 2;
        this.top = (this.field_22790 - this.getMenuHeight()) / 2;
        super.method_25426();
        this.statGridWidget = new StatGridWidget(this, this.left + 7, this.top + 40);
        this.statGridWidget.field_22764 = true;
        this.statGridWidget.setOnAttributeHover(attribute -> {
            this.hoveredAttribute = attribute;
        });
        this.method_37063((class_364)this.statGridWidget);
        this.reallocateButton = GUIHelper.button(this.left + this.getMenuWidth() - 17, this.top + 5, "widgets/reallocate", "menu.blockgame.stats.reallocate", button -> this.screenManager.getStatAllocator().resetStats());
        this.reallocateButton.field_22764 = this.screenManager.getSyncId() != -1;
        this.method_37063((class_364)this.reallocateButton);
        this.addProfileButton = GUIHelper.button(this.left + 7, this.top + 5 + 17, "widgets/create", "menu.blockgame.stats.create_profile", button -> {
            this.previewingProfile = null;
            this.openProfilePreview();
        });
        this.addProfileButton.field_22764 = !this.screenManager.getStatAllocator().isPreview();
        this.method_37063((class_364)this.addProfileButton);
        this.profileButtons = new HashMap<String, class_344>();
        if (BlockgameData.INSTANCE != null) {
            ArrayList<StatProfile> profiles = new ArrayList<StatProfile>(BlockgameData.INSTANCE.getStatProfiles().values());
            profiles.sort(Comparator.comparingInt(StatProfile::getOrder));
            for (int i = 0; i < profiles.size(); ++i) {
                this.addProfileButton(profiles.get(i), i);
            }
        }
        this.profileNameField = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.left + 8, this.top + 6 + 17, this.getMenuWidth() - 16, 12, this.profileNameField, (class_2561)class_2561.method_43470((String)"")));
        this.profileNameField.method_47404((class_2561)class_2561.method_43471((String)"menu.blockgame.stats.profile_placeholder"));
        this.profileNameField.method_1858(true);
        this.profileNameField.method_1868(0xFFFFFF);
        this.profileNameField.field_22764 = this.screenManager.getStatAllocator().isPreview();
        this.cancelPreviewButton = GUIHelper.button(this.left + this.getMenuWidth() - 34, this.top + 5, "widgets/close", "menu.blockgame.stats.cancel_preview", button -> this.closeProfilePreview());
        this.cancelPreviewButton.field_22764 = this.screenManager.getStatAllocator().isPreview();
        this.method_37063((class_364)this.cancelPreviewButton);
        this.saveProfileButton = GUIHelper.button(this.left + this.getMenuWidth() - 51, this.top + 5, "widgets/save_profile", "menu.blockgame.stats.save_profile", button -> {
            int order;
            if (this.previewingProfile != null) {
                BlockgameData.removeProfile(this.previewingProfile.getName());
                order = this.previewingProfile.getOrder();
            } else {
                order = 0;
                for (StatProfile profile : BlockgameData.INSTANCE.getStatProfiles().values()) {
                    if (profile.getOrder() < order) continue;
                    order = profile.getOrder() + 1;
                }
            }
            StatProfile newProfile = new StatProfile(this.profileNameField.method_1882(), order);
            newProfile.fromAttributes(this.screenManager.getStatAllocator().getAttributes());
            BlockgameData.saveProfile(newProfile);
            if (this.previewingProfile != null) {
                class_344 existingButton = this.profileButtons.get(this.previewingProfile.getName());
                if (existingButton != null) {
                    existingButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)newProfile.getName())));
                }
            } else {
                this.addProfileButton(newProfile, this.profileButtons.size());
            }
            this.closeProfilePreview();
            this.adjustProfileButtons();
            this.getScreenManager().getStatAllocator().allocate(newProfile);
        });
        this.saveProfileButton.field_22764 = this.screenManager.getStatAllocator().isPreview();
        this.method_37063((class_364)this.saveProfileButton);
        this.deleteProfileButton = GUIHelper.button(this.left + 7, this.top + this.getMenuHeight() - 17 - 3, "widgets/remove", "menu.blockgame.stats.delete_profile", button -> {
            if (this.previewingProfile != null) {
                BlockgameData.removeProfile(this.previewingProfile.getName());
                this.method_37066((class_364)this.profileButtons.remove(this.previewingProfile.getName()));
                this.closeProfilePreview();
                this.adjustProfileButtons();
            }
        });
        this.deleteProfileButton.field_22764 = this.screenManager.getStatAllocator().isPreview();
        this.method_37063((class_364)this.deleteProfileButton);
        int modifierListWidth = Math.min(200, this.field_22789 - (this.left + this.getMenuWidth() + 4));
        this.modifierListWidget = new ModifierListWidget(this, this.field_22789 - modifierListWidth, 0, modifierListWidth, this.field_22790);
        this.modifierListWidget.field_22764 = false;
        this.method_37063((class_364)this.modifierListWidget);
        this.adjustProfileButtons();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_51439(this.field_22793, this.field_22785, this.left + 8, this.top + 8, 0xFFFFFF, false);
        int totalPoints = this.screenManager.getStatAllocator().getTotalPoints();
        class_5250 text = class_2561.method_43471((String)"menu.blockgame.stats.available");
        if (totalPoints == -1) {
            text.method_10852((class_2561)class_2561.method_43470((String)"?").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}));
        } else {
            text.method_10852((class_2561)class_2561.method_43470((String)("" + this.screenManager.getStatAllocator().getAvailablePoints())).method_27695(new class_124[]{this.screenManager.getStatAllocator().getAvailablePoints() > 0 ? class_124.field_1060 : class_124.field_1061, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)("/" + totalPoints)));
        }
        int availableX = this.left + (this.getMenuWidth() - this.field_22793.method_27525((class_5348)text)) / 2;
        int availableY = this.top + 40 + 108 + 7;
        context.method_51439(this.field_22793, (class_2561)text, availableX, availableY, 0xFFFFFF, false);
        this.renderTooltip(context, mouseX, mouseY);
    }

    private void renderTooltip(class_332 context, int mouseX, int mouseY) {
        if (this.hoveredAttribute == null) {
            return;
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
        context.method_51446(this.field_22793, this.hoveredAttribute.getItemStack(), mouseX, mouseY);
        context.method_51448().method_22909();
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25420(context, mouseX, mouseY, delta);
        if (this.screenManager.getStatAllocator().isPreview()) {
            context.method_25296(this.left - 1, this.top - 1, this.left + this.getMenuWidth() + 2, this.top + this.getMenuHeight() + 2, -1996760212, -1996760212);
        }
        context.method_52706(BACKGROUND_SPRITE, this.left, this.top, this.getMenuWidth(), this.getMenuHeight());
    }

    public void method_25419() {
        super.method_25419();
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.field_22787.field_1724.method_7346();
        }
        this.screenManager.onScreenClose();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 69) {
            for (class_344 button : this.profileButtons.values()) {
                if (!button.method_49606()) continue;
                this.isEditing = true;
                button.method_25306();
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void onReallocationSlotSet() {
        this.reallocateButton.field_22764 = true;
    }

    public void onAttributesChanged() {
        this.modifierListWidget.build();
    }

    public int getMenuWidth() {
        return 176;
    }

    public int getMenuHeight() {
        return 172;
    }

    private void openProfilePreview() {
        this.screenManager.getStatAllocator().setPreview(true, this.previewingProfile);
        this.addProfileButton.field_22764 = false;
        for (class_344 button : this.profileButtons.values()) {
            button.field_22764 = false;
        }
        this.saveProfileButton.field_22764 = true;
        this.deleteProfileButton.field_22764 = true;
        this.cancelPreviewButton.field_22764 = true;
        this.profileNameField.field_22764 = true;
        if (this.previewingProfile == null) {
            this.profileNameField.method_1852("");
        }
    }

    private void closeProfilePreview() {
        this.screenManager.getStatAllocator().setPreview(false);
        this.addProfileButton.field_22764 = true;
        for (class_344 button : this.profileButtons.values()) {
            button.field_22764 = true;
        }
        this.saveProfileButton.field_22764 = false;
        this.deleteProfileButton.field_22764 = false;
        this.cancelPreviewButton.field_22764 = false;
        this.profileNameField.field_22764 = false;
        this.previewingProfile = null;
    }

    private void adjustProfileButtons() {
        if (BlockgameData.INSTANCE == null) {
            return;
        }
        Map<String, StatProfile> statProfiles = BlockgameData.INSTANCE.getStatProfiles();
        this.addProfileButton.field_22764 = !this.screenManager.getStatAllocator().isPreview() && statProfiles.size() < 5;
        this.addProfileButton.method_46421(this.left + 7 + 17 * statProfiles.size());
        Map<String, PlayerAttribute> attributes = this.screenManager.getStatAllocator().getAttributes();
        ArrayList<StatProfile> profiles = new ArrayList<StatProfile>(statProfiles.values());
        profiles.sort(Comparator.comparingInt(StatProfile::getOrder));
        for (int i = 0; i < profiles.size(); ++i) {
            StatProfile profile = profiles.get(i);
            class_344 button = this.profileButtons.get(profile.getName());
            if (button == null) continue;
            button.method_46421(this.left + 7 + 17 * i);
            class_7919 tooltip = class_7919.method_47407((class_2561)class_2561.method_43473());
            tooltip.field_41103 = new ArrayList();
            tooltip.field_41103.add(class_2561.method_43470((String)profile.getName()).method_30937());
            if (profile.matches(attributes)) {
                tooltip.field_41103.add(class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43471((String)"menu.blockgame.stats.current").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)")")).method_30937());
                button.field_45356 = new class_8666(GUIHelper.sprite("widgets/current_profile/button"), GUIHelper.sprite("widgets/current_profile/button_highlighted"));
            } else {
                button.field_45356 = new class_8666(GUIHelper.sprite("widgets/change_profile/button"), GUIHelper.sprite("widgets/change_profile/button_highlighted"));
            }
            tooltip.field_41103.add(class_2561.method_43473().method_30937());
            tooltip.field_41103.add(class_2561.method_43470((String)"Left-click to select").method_27692(class_124.field_1080).method_30937());
            tooltip.field_41103.add(class_2561.method_43470((String)"Press ").method_10852((class_2561)class_2561.method_43470((String)"E").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to edit")).method_30937());
            button.method_47400(tooltip);
        }
    }

    private void addProfileButton(StatProfile profile, int index) {
        class_344 button = GUIHelper.button(this.left + 7 + 17 * index, this.top + 5 + 17, "widgets/change_profile", profile.getName(), b -> {
            if (this.isEditing) {
                this.previewingProfile = profile;
                this.profileNameField.method_1852(profile.getName());
                this.openProfilePreview();
                this.isEditing = false;
            } else {
                this.screenManager.getStatAllocator().allocate(profile);
                this.adjustProfileButtons();
            }
        });
        this.profileButtons.put(profile.getName(), button);
        this.method_37063((class_364)button);
    }

    public StatScreenManager getScreenManager() {
        return this.screenManager;
    }
}

