/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.blockgameprofiles.gamefeature.statprofiles.gui.widget;

import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.attribute.PlayerAttribute;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.gui.screen.StatScreen;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.gui.widget.ScrollableViewWidget;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.modifier.ModifierCategory;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.modifier.ModifierDisplay;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.modifier.ModifierType;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.modifier.StatModifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ModifierListWidget
extends ScrollableViewWidget {
    private final StatScreen parent;
    private int bottomY = 0;
    private final Map<ModifierCategory, List<ModifierDisplay>> categoryModifiers = new HashMap<ModifierCategory, List<ModifierDisplay>>();

    public ModifierListWidget(StatScreen parent, int x, int y, int width, int height) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.parent = parent;
    }

    public void build() {
        this.categoryModifiers.clear();
        HashMap<String, ModifierDisplay> modifiers = new HashMap<String, ModifierDisplay>();
        Map<String, PlayerAttribute> attributes = this.parent.getScreenManager().getStatAllocator().getAttributes();
        if (attributes != null) {
            for (PlayerAttribute attr : attributes.values()) {
                for (StatModifier buff : attr.getBuffs()) {
                    if (!modifiers.containsKey(buff.getName())) {
                        modifiers.put(buff.getName(), new ModifierDisplay(buff.getName(), buff.getType(), buff.getCategory()));
                    }
                    ((ModifierDisplay)modifiers.get(buff.getName())).addValue(buff.getValue() * (double)attr.getSpent());
                }
            }
        }
        for (ModifierDisplay modifier : modifiers.values()) {
            if (modifier.getValue() == 0.0) continue;
            this.categoryModifiers.compute(modifier.getCategory(), (modifierCategory, modifierDisplays) -> {
                if (modifierDisplays == null) {
                    modifierDisplays = new ArrayList<ModifierDisplay>();
                }
                modifierDisplays.add(modifier);
                return modifierDisplays;
            });
        }
        this.categoryModifiers.values().forEach(modifierList -> modifierList.sort(Comparator.comparingInt(ModifierDisplay::getOrder)));
        this.field_22764 = true;
    }

    protected void method_44389(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.categoryModifiers.isEmpty()) {
            return;
        }
        context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), Math.max(this.bottomY + 4, this.field_22759), Integer.MIN_VALUE);
        int y = this.method_46427() + 8;
        int x = this.method_46426() + 8;
        int maxW = 0;
        class_327 textRenderer = class_310.method_1551().field_1772;
        boolean previousDisplay = false;
        for (ModifierCategory category : ModifierCategory.values()) {
            List displays = this.categoryModifiers.getOrDefault((Object)category, new ArrayList());
            if (displays.isEmpty()) continue;
            if (previousDisplay) {
                y += 8;
            }
            class_5250 titleText = class_2561.method_43470((String)category.title).method_27692(class_124.field_1067);
            maxW = Math.max(maxW, textRenderer.method_27525((class_5348)titleText));
            context.method_27535(textRenderer, (class_2561)titleText, x, y, 0xFFFFFF);
            y += 12;
            for (ModifierDisplay display : displays) {
                class_5250 modifierText = this.getModifierText(display);
                maxW = Math.max(maxW, textRenderer.method_27525((class_5348)modifierText));
                context.method_51439(textRenderer, (class_2561)modifierText, x, y, 0xFFFFFF, false);
                y += 12;
            }
            previousDisplay = true;
        }
        this.bottomY = y;
        this.method_25358(Math.max(maxW + 8, this.method_25368()));
        this.method_46421(this.parent.field_22789 - this.method_25368());
    }

    protected int method_44391() {
        return this.bottomY - this.method_46427();
    }

    private class_5250 getModifierText(ModifierDisplay modifier) {
        double value = modifier.getValue();
        Object valueStr = String.format("%.2f", value);
        if (((String)valueStr).contains(".") && ((String)valueStr).endsWith("0") && ((String)(valueStr = ((String)valueStr).replaceAll("0*$", ""))).endsWith(".")) {
            valueStr = ((String)valueStr).substring(0, ((String)valueStr).length() - 1);
        }
        if (modifier.getType() == ModifierType.RELATIVE) {
            valueStr = (String)valueStr + "%";
        }
        if (value > 0.0) {
            valueStr = "+" + (String)valueStr;
        }
        return class_2561.method_43470((String)(modifier.getIcon() + " " + modifier.getDisplayName() + ": ")).method_10852((class_2561)class_2561.method_43470((String)valueStr).method_27692(modifier.getValueColor())).method_27692(class_124.field_1080);
    }
}

