/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.blockgameprofiles.gamefeature.statprofiles.gui.widget;

import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.attribute.PlayerAttribute;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.gui.screen.StatScreen;
import dev.bnjc.blockgameprofiles.helper.GUIHelper;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class StatGridWidget
extends class_339 {
    public static final int GRID_SLOT_SIZE = 18;
    private static final class_2960 BACKGROUND = GUIHelper.sprite("widgets/slot_background");
    private static final int GRID_COLUMNS = 9;
    private static final int GRID_ROWS = 6;
    private final StatScreen screen;
    private int mouseClickButton;
    @Nullable
    private Consumer<PlayerAttribute> onAttributeHover;

    public StatGridWidget(StatScreen screen, int x, int y) {
        super(x, y, 162, 108, (class_2561)class_2561.method_43473());
        this.screen = screen;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.mouseClickButton = button;
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25348(double mouseX, double mouseY) {
        int x = (int)((mouseX - (double)this.method_46426()) / 18.0);
        int y = (int)((mouseY - (double)this.method_46427()) / 18.0);
        int slot = y * 9 + x;
        Map<String, PlayerAttribute> attributes = this.screen.getScreenManager().getStatAllocator().getAttributes();
        if (attributes == null) {
            return;
        }
        for (PlayerAttribute attr : attributes.values()) {
            if (!attr.getSlots().contains(slot)) continue;
            if (this.mouseClickButton == 0) {
                this.screen.getScreenManager().getStatAllocator().incrementStat(attr);
                break;
            }
            if (this.mouseClickButton != 1) break;
            this.screen.getScreenManager().getStatAllocator().decrementStat(attr);
            break;
        }
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_52706(BACKGROUND, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        this.renderItems(context);
        this.renderTooltip(context, mouseX, mouseY);
    }

    private void renderItems(class_332 context) {
        Map<String, PlayerAttribute> attributes = this.screen.getScreenManager().getStatAllocator().getAttributes();
        if (attributes == null) {
            return;
        }
        int barColor = class_3532.method_15369((float)0.33333334f, (float)1.0f, (float)1.0f);
        if (this.screen.getScreenManager().getStatAllocator().isPreview()) {
            barColor = 16503134;
        }
        for (PlayerAttribute attr : attributes.values()) {
            for (int slot : attr.getSlots()) {
                int x = this.method_46426() + 18 * (slot % 9);
                int y = this.method_46427() + 18 * (slot / 9);
                context.method_51427(attr.getItemStack(), x + 1, y + 1);
                int barX = x + 2;
                int barY = y + 14;
                int barWidth = 14;
                context.method_51739(class_1921.method_51785(), barX, barY, barX + barWidth, barY + 2, -16777216);
                context.method_51739(class_1921.method_51785(), barX, barY, barX + attr.getBarStep(barWidth), barY + 1, barColor | 0xFF000000);
            }
        }
    }

    private void renderTooltip(class_332 context, int mouseX, int mouseY) {
        if (!this.method_49606()) {
            this.setHoveredAttribute(null);
            return;
        }
        int x = (mouseX - this.method_46426()) / 18;
        int y = (mouseY - this.method_46427()) / 18;
        if (x < 0 || x > 9 || y < 0 || y >= 6) {
            this.setHoveredAttribute(null);
            return;
        }
        int slotX = this.method_46426() + x * 18;
        int slotY = this.method_46427() + y * 18;
        context.method_25294(slotX + 1, slotY + 1, slotX + 18 - 1, slotY + 18 - 1, -2130706433);
        Map<String, PlayerAttribute> attributes = this.screen.getScreenManager().getStatAllocator().getAttributes();
        if (attributes == null) {
            this.setHoveredAttribute(null);
            return;
        }
        PlayerAttribute foundAttr = null;
        int slot = y * 9 + x;
        for (PlayerAttribute attr : attributes.values()) {
            if (!attr.getSlots().contains(slot)) continue;
            foundAttr = attr;
            break;
        }
        this.setHoveredAttribute(foundAttr);
    }

    private void setHoveredAttribute(@Nullable PlayerAttribute attribute) {
        if (this.onAttributeHover != null) {
            if (attribute != null) {
                attribute.fixLoreText();
            }
            this.onAttributeHover.accept(attribute);
        }
    }

    protected void method_47399(class_6382 builder) {
    }

    protected boolean method_25351(int button) {
        return button == 0 || button == 1;
    }

    public StatScreen getScreen() {
        return this.screen;
    }

    public void setOnAttributeHover(@Nullable Consumer<PlayerAttribute> onAttributeHover) {
        this.onAttributeHover = onAttributeHover;
    }
}

