/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.blockgameprofiles.gamefeature.statprofiles.modifier;

import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.modifier.ModifierCategory;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.modifier.ModifierType;
import net.minecraft.class_124;

public class ModifierDisplay {
    private final String name;
    private final ModifierType type;
    private final ModifierCategory category;
    private final int order;
    private final String icon;
    private double value;

    public ModifierDisplay(String name, ModifierType type, ModifierCategory category) {
        this.name = name;
        this.type = type;
        this.category = category;
        this.order = ModifierDisplay.getOrder(name);
        this.icon = ModifierDisplay.getIcon(name);
        this.value = 0.0;
    }

    public void addValue(double value) {
        this.value += value;
    }

    public String getDisplayName() {
        return switch (this.name) {
            case "Critical Strike Chance" -> "Critical Chance";
            case "Critical Strike Power" -> "Critical Power";
            case "Health Regeneration" -> "Health Regen";
            default -> this.name;
        };
    }

    public class_124 getValueColor() {
        if (this.value > 0.0) {
            return class_124.field_1060;
        }
        if (this.value < 0.0) {
            return class_124.field_1061;
        }
        return class_124.field_1068;
    }

    private static String getIcon(String name) {
        return switch (name) {
            case "Critical Strike Chance", "Critical Strike Power", "All Damage", "Weapon Damage", "Backstab Damage", "PVE Damage", "PVP Damage" -> "\ud83d\udde1";
            case "Magic Damage" -> "\u2604";
            case "Projectile Damage" -> "\ud83c\udff9";
            case "Thaumaturgy Power" -> "\u262e";
            case "AOE Size Amplifier" -> "\u25ce";
            case "Cooldown Reduction" -> "\u23f3";
            case "Movement Speed" -> "\u231a";
            case "Max Health", "Health Regeneration", "Healing Received" -> "\u2764";
            case "Defense", "Block Cooldown Reduction", "Block Power", "Block Rating", "Knockback Resistance", "Damage Reduction", "PVE Damage Reduction", "PVP Damage Reduction" -> "\u26e8";
            case "Threat" -> "\u26a0";
            case "Mining Skill" -> "\u26cf";
            case "Logging Skill" -> "\ud83e\ude93";
            case "Archaeology Skill" -> "\u2620";
            case "Fishing Skill" -> "\ud83c\udfa3";
            case "Herbalism Skill" -> "\u2618";
            case "Hunting Skill" -> "\ud83d\udc3a";
            default -> "?";
        };
    }

    private static int getOrder(String name) {
        return switch (name) {
            case "Critical Strike Chance" -> 0;
            case "Critical Strike Power" -> 1;
            case "All Damage" -> 2;
            case "Weapon Damage" -> 3;
            case "Magic Damage" -> 4;
            case "Projectile Damage" -> 5;
            case "Thaumaturgy Power" -> 6;
            case "Backstab Damage" -> 7;
            case "PVE Damage" -> 8;
            case "PVP Damage" -> 9;
            case "AOE Size Amplifier" -> 10;
            case "Cooldown Reduction" -> 11;
            case "Movement Speed" -> 12;
            case "Threat" -> 13;
            case "Max Health" -> 14;
            case "Health Regeneration" -> 15;
            case "Healing Received" -> 16;
            case "Defense" -> 17;
            case "Block Rating" -> 18;
            case "Block Power" -> 19;
            case "Block Cooldown Reduction" -> 20;
            case "Knockback Resistance" -> 21;
            case "Damage Reduction" -> 22;
            case "PVE Damage Reduction" -> 23;
            case "PVP Damage Reduction" -> 24;
            case "Mining Skill" -> 25;
            case "Logging Skill" -> 26;
            case "Archaeology Skill" -> 27;
            case "Fishing Skill" -> 28;
            case "Herbalism Skill" -> 29;
            case "Hunting Skill" -> 30;
            default -> -1;
        };
    }

    public String getName() {
        return this.name;
    }

    public ModifierType getType() {
        return this.type;
    }

    public ModifierCategory getCategory() {
        return this.category;
    }

    public int getOrder() {
        return this.order;
    }

    public String getIcon() {
        return this.icon;
    }

    public double getValue() {
        return this.value;
    }
}

