/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.blockgameprofiles.gamefeature.statprofiles.modifier;

import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.modifier.ModifierCategory;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.modifier.ModifierType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class StatModifier {
    private static final Pattern LORE_PATTERN = Pattern.compile(".*([+-][0-9.]+)(%?) (.+) \\(([+-]?[0-9.]+)(%?)\\).*");
    private final String name;
    private final double value;
    private final double playerValue;
    private final ModifierType type;
    private final ModifierCategory category;

    public StatModifier(String name, double value, double playerValue, ModifierType type) {
        this.name = name;
        this.value = value;
        this.playerValue = playerValue;
        this.type = type;
        this.category = this.determineCategory(name);
    }

    public class_5250 toLore(int count) {
        double newPlayerValue = this.value * (double)count;
        return class_2561.method_43470((String)"  ").method_27692(class_124.field_1080).method_27693(this.value > 0.0 ? "+" : "").method_27693(String.format("%.1f", this.value)).method_27693(this.type == ModifierType.RELATIVE ? "%" : "").method_27693(" " + this.name).method_27693(" (").method_10852((class_2561)class_2561.method_43470((String)(newPlayerValue > 0.0 ? "+" : "")).method_27693(String.format("%.1f", newPlayerValue)).method_27693(this.type == ModifierType.RELATIVE ? "%" : "").method_27692(this.playerValue > 0.0 ? class_124.field_1060 : (this.playerValue < 0.0 ? class_124.field_1061 : class_124.field_1068))).method_27693(")");
    }

    @Nullable
    public static StatModifier fromLore(String lore) {
        if (lore.isEmpty()) {
            return null;
        }
        Matcher matcher = LORE_PATTERN.matcher(lore);
        if (!matcher.matches()) {
            return null;
        }
        String name = matcher.group(3);
        double value = Double.parseDouble(matcher.group(1));
        double playerValue = Double.parseDouble(matcher.group(4));
        ModifierType type = ModifierType.FLAT;
        if (matcher.group(2).equals("%")) {
            type = ModifierType.RELATIVE;
        }
        return new StatModifier(name, value, playerValue, type);
    }

    private ModifierCategory determineCategory(String name) {
        return switch (name) {
            case "Critical Strike Chance", "Critical Strike Power", "All Damage", "Weapon Damage", "Magic Damage", "Projectile Damage", "Thaumaturgy Power", "Backstab Damage", "PVE Damage", "PVP Damage", "AOE Size Amplifier", "Cooldown Reduction", "Movement Speed", "Threat" -> ModifierCategory.OFFENSE;
            case "Max Health", "Health Regeneration", "Healing Received", "Defense", "Block Rating", "Block Power", "Block Cooldown Reduction", "Knockback Resistance", "Damage Reduction", "PVE Damage Reduction", "PVP Damage Reduction" -> ModifierCategory.DEFENSE;
            case "Mining Skill", "Logging Skill", "Archaeology Skill", "Fishing Skill", "Herbalism Skill", "Hunting Skill" -> ModifierCategory.PROFESSION;
            default -> ModifierCategory.UNKNOWN;
        };
    }

    public String toString() {
        return "StatModifier{name='" + this.name + "', value=" + this.value + ", playerValue=" + this.playerValue + ", type=" + String.valueOf((Object)this.type) + ", category=" + String.valueOf((Object)this.category) + "}";
    }

    public String getName() {
        return this.name;
    }

    public double getValue() {
        return this.value;
    }

    public double getPlayerValue() {
        return this.playerValue;
    }

    public ModifierType getType() {
        return this.type;
    }

    public ModifierCategory getCategory() {
        return this.category;
    }
}

