/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.blockgameprofiles.helper;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.bnjc.blockgameprofiles.BlockgameProfiles;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2509;

public class FileHelper {
    private static final String BLOCKGAME_FOLDER_NAME = "blockgame";
    private static final Path GAME_FOLDER_PATH = Path.of(String.valueOf(FabricLoader.getInstance().getConfigDir()) + "/blockgame", new String[0]);

    public static Path getBlockgamePath() {
        if (Files.notExists(GAME_FOLDER_PATH, new LinkOption[0])) {
            Files.createDirectory(GAME_FOLDER_PATH, new FileAttribute[0]);
        }
        return Path.of(String.valueOf(GAME_FOLDER_PATH) + "/", new String[0]);
    }

    public static <T> boolean saveToNbt(T object, Codec<T> codec, Path path) {
        try {
            Object t;
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Either tag = codec.encodeStart((DynamicOps)class_2509.field_11560, object).get();
            Optional result = tag.left();
            Optional err = tag.right();
            if (err.isPresent()) {
                throw new IOException("Error encoding to NBT %s".formatted(err.get()));
            }
            if (result.isPresent() && (t = result.get()) instanceof class_2487) {
                class_2487 compoundTag = (class_2487)t;
                class_2507.method_30614((class_2487)compoundTag, (File)path.toFile());
                return true;
            }
            throw new IOException("Error encoding to NBT: %s".formatted(result));
        }
        catch (IOException ex) {
            BlockgameProfiles.LOGGER.error("[Blockgame Profiles] Error saving NBT to {}", (Object)path, (Object)ex);
            return false;
        }
    }

    public static <T> Optional<T> loadFromNbt(Codec<T> codec, Path path) {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try {
                FileInputStream stream = new FileInputStream(path.toFile());
                class_2487 tag = class_2507.method_10629((InputStream)stream);
                Either loaded = codec.decode((DynamicOps)class_2509.field_11560, (Object)tag).get();
                if (loaded.right().isPresent()) {
                    throw new IOException("Invalid NBT: %s".formatted(loaded.right().get()));
                }
                return Optional.ofNullable(((Pair)loaded.left().get()).getFirst());
            }
            catch (IOException ex) {
                BlockgameProfiles.LOGGER.error("[Blockgame Profiles] Error loading NBT from {}", (Object)path, (Object)ex);
                FileHelper.tryMove(path, path.resolveSibling(String.valueOf(path.getFileName()) + ".corrupted"), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return Optional.empty();
    }

    public static void tryMove(Path from, Path to, CopyOption ... options) {
        try {
            Files.move(from, to, options);
        }
        catch (IOException ex) {
            BlockgameProfiles.LOGGER.error("[Blockgame Profiles] Error moving file from {} to {}", new Object[]{from, to, ex});
        }
    }

    public static boolean deleteIfExists(Path to) {
        try {
            Files.deleteIfExists(to);
            return true;
        }
        catch (IOException ex) {
            BlockgameProfiles.LOGGER.error("[Blockgame Profiles] Error deleting file {}", (Object)to, (Object)ex);
            return false;
        }
    }
}

