/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.blockgameprofiles.storage;

import com.mojang.serialization.Codec;
import dev.bnjc.blockgameprofiles.BlockgameProfiles;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.allocate.StatProfile;
import dev.bnjc.blockgameprofiles.storage.Storage;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class BlockgameData {
    public static final Codec<Map<String, StatProfile>> STAT_PROFILES_CODEC = Codec.unboundedMap((Codec)Codec.STRING, StatProfile.CODEC).xmap(HashMap::new, Function.identity());
    @Nullable
    public static BlockgameData INSTANCE = null;
    private final Map<String, StatProfile> statProfiles = new HashMap<String, StatProfile>();

    public static void loadOrCreate() {
        BlockgameData.unload();
        INSTANCE = Storage.load().orElseGet(BlockgameData::new);
        BlockgameData.save();
    }

    public static void save() {
        if (INSTANCE == null) {
            return;
        }
        Storage.save(INSTANCE);
        BlockgameProfiles.LOGGER.debug("Blockgame data saved");
    }

    public static void unload() {
        if (INSTANCE == null) {
            return;
        }
        Storage.save(INSTANCE);
        INSTANCE = null;
        BlockgameProfiles.LOGGER.debug("Blockgame data unloaded");
    }

    public static void saveProfile(StatProfile profile) {
        if (INSTANCE == null) {
            return;
        }
        BlockgameProfiles.LOGGER.debug("Saving profile: \"{}\"", (Object)profile.getName());
        BlockgameData.INSTANCE.statProfiles.put(profile.getName(), profile);
        BlockgameData.save();
    }

    public static void removeProfile(String name) {
        if (INSTANCE == null) {
            return;
        }
        BlockgameProfiles.LOGGER.debug("Removing profile: \"{}\"", (Object)name);
        BlockgameData.INSTANCE.statProfiles.remove(name);
        BlockgameData.save();
    }

    public Map<String, StatProfile> getStatProfiles() {
        return this.statProfiles;
    }
}

