/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.blockgameprofiles.storage;

import dev.bnjc.blockgameprofiles.BlockgameProfiles;
import dev.bnjc.blockgameprofiles.storage.BlockgameData;
import dev.bnjc.blockgameprofiles.storage.backend.Backend;
import java.util.Optional;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_433;
import org.jetbrains.annotations.Nullable;

public class Storage {
    private static Backend backend;

    public static void setup() {
        BlockgameProfiles.getConfig().getStorageConfig().backendType.load();
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> client.execute(BlockgameData::loadOrCreate));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> BlockgameData.unload());
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_433) {
                BlockgameData.save();
            }
        });
    }

    public static Optional<BlockgameData> load() {
        if (BlockgameData.INSTANCE != null) {
            return Optional.of(BlockgameData.INSTANCE);
        }
        BlockgameData data = backend.load();
        if (data == null) {
            return Optional.empty();
        }
        return Optional.of(data);
    }

    public static void save(@Nullable BlockgameData data) {
        if (data == null) {
            BlockgameProfiles.LOGGER.warn("BlockgameData is null, not saving");
            return;
        }
        boolean saved = backend.save(data);
        if (!saved) {
            BlockgameProfiles.LOGGER.error("Failed to save BlockgameData");
        }
    }

    public static void setBackend(Backend backend) {
        Storage.backend = backend;
    }
}

