/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.blockgameprofiles.storage.backend;

import dev.bnjc.blockgameprofiles.BlockgameProfiles;
import dev.bnjc.blockgameprofiles.gamefeature.statprofiles.allocate.StatProfile;
import dev.bnjc.blockgameprofiles.helper.FileHelper;
import dev.bnjc.blockgameprofiles.storage.BlockgameData;
import dev.bnjc.blockgameprofiles.storage.backend.FileBasedBackend;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class NbtBackend
extends FileBasedBackend {
    @Override
    @Nullable
    public BlockgameData load() {
        BlockgameData data = new BlockgameData();
        data.getStatProfiles().putAll(this.loadStatProfiles());
        return data;
    }

    @Override
    public boolean save(BlockgameData data) {
        boolean result = FileHelper.saveToNbt(data.getStatProfiles(), BlockgameData.STAT_PROFILES_CODEC, FileHelper.getBlockgamePath().resolve("stat_profiles" + this.extension()));
        return result;
    }

    private Map<String, StatProfile> loadStatProfiles() {
        Path statProfilesPath = FileHelper.getBlockgamePath().resolve("stat_profiles" + this.extension());
        Optional<Map<String, StatProfile>> result = FileHelper.loadFromNbt(BlockgameData.STAT_PROFILES_CODEC, statProfilesPath);
        if (result.isPresent()) {
            return result.get();
        }
        BlockgameProfiles.LOGGER.warn("Failed to load stat profiles from {}", (Object)statProfilesPath);
        return new HashMap<String, StatProfile>();
    }

    @Override
    public String extension() {
        return ".nbt";
    }
}

