/*
 * Decompiled with CFR 0.152.
 */
package com.ev.bedrockcaseopening;

import com.ev.bedrockcaseopening.ItemEnum;
import com.ev.bedrockcaseopening.MyConfig;
import com.ev.bedrockcaseopening.TextureData;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.util.ResourceLocation;

public class CitManager {
    private static final Map<String, TextureData> citCache = new HashMap<String, TextureData>();
    private IResourceManager rm = Minecraft.func_71410_x().func_110442_L();

    public CitManager() {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(manager -> {
            try {
                System.out.println("[BCCO] CIT Cache building...");
                this.rebuildCache();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private void rebuildCache() throws IOException {
        citCache.clear();
        for (ResourcePackRepository.Entry entry : Minecraft.func_71410_x().func_110438_M().func_110613_c()) {
            IResourcePack pack = entry.func_110514_c();
            Set<String> propertyFiles = this.listFiles(pack, "mcpatcher/cit", ".properties");
            for (String path : propertyFiles) {
                try {
                    InputStream in = pack.func_110590_a(new ResourceLocation("minecraft", path));
                    Throwable throwable = null;
                    try {
                        Properties props = new Properties();
                        props.load(in);
                        this.checkID(props, path);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        System.out.println("[BCCO] CIT Cache built with " + citCache.size() + " entries.");
    }

    private void checkID(Properties props, String path) {
        String prefix;
        String texturePath;
        String folder;
        String nbtId = props.getProperty("nbt.ExtraAttributes.id");
        String itemType = props.getProperty("items", "");
        if ("minecraft:enchanted_book".equals(itemType)) {
            for (String key : props.stringPropertyNames()) {
                if (!key.startsWith("nbt.ExtraAttributes.enchantments.")) continue;
                String enchantName = key.substring("nbt.ExtraAttributes.enchantments.".length());
                String level = props.getProperty(key);
                nbtId = enchantName + "_" + level;
                break;
            }
        }
        if (nbtId == null) {
            return;
        }
        try {
            ItemEnum itemEnum = ItemEnum.valueOf(nbtId);
        }
        catch (IllegalArgumentException ignored) {
            return;
        }
        String textureProp = props.getProperty("texture");
        int lastSlash = path.lastIndexOf(47);
        String string = folder = lastSlash >= 0 ? path.substring(0, lastSlash) : "";
        if (textureProp != null && !textureProp.isEmpty()) {
            texturePath = textureProp;
            texturePath = texturePath.startsWith("/") ? texturePath.substring(1) : folder + "/" + texturePath;
            if (texturePath.endsWith(".png")) {
                texturePath = texturePath.substring(0, texturePath.length() - 4);
            }
        } else {
            String baseName = path.substring(lastSlash + 1, path.length() - ".properties".length());
            texturePath = folder + "/" + baseName;
        }
        if (texturePath.startsWith(prefix = "assets/minecraft/")) {
            texturePath = texturePath.substring(prefix.length());
        }
        ResourceLocation rl = new ResourceLocation("minecraft", texturePath + ".png");
        int frameTime = this.getFrameTime(this.rm, rl);
        int frames = CitManager.getFrames(this.rm, rl);
        citCache.put(nbtId, new TextureData(rl, frameTime, frames));
        if (MyConfig.debugMode) {
            System.out.println(nbtId + " : " + texturePath + ".png");
        }
    }

    private int getFrameTime(IResourceManager rm, ResourceLocation rl) {
        try {
            JsonObject anim;
            ResourceLocation metaLoc = new ResourceLocation(rl.func_110624_b(), rl.func_110623_a() + ".mcmeta");
            IResource res = rm.func_110536_a(metaLoc);
            if (res == null) {
                return 1;
            }
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse((Reader)new InputStreamReader(res.func_110527_b())).getAsJsonObject();
            if (root.has("animation") && (anim = root.getAsJsonObject("animation")).has("frametime")) {
                int ft = anim.get("frametime").getAsInt();
                return ft;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFrames(IResourceManager rm, ResourceLocation rl) {
        int n;
        InputStream stream = null;
        try {
            IResource res = rm.func_110536_a(rl);
            stream = res.func_110527_b();
            BufferedImage img = ImageIO.read(stream);
            if (img == null) {
                int n2 = 1;
                return n2;
            }
            int width = img.getWidth();
            int height = img.getHeight();
            n = Math.max(height / width, 1);
        }
        catch (Exception e) {
            int n3 = 1;
            return n3;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
        return n;
    }

    public static TextureData getTextureData(String nbtId) {
        TextureData data = citCache.getOrDefault(nbtId, new TextureData(ItemEnum.valueOf(nbtId).getDefaultRl(), 1, 1));
        return data;
    }

    private Set<String> listFiles(IResourcePack pack, String folder, String ext) throws IOException {
        HashSet<String> result = new HashSet<String>();
        File base = this.getPackFile(pack);
        if (base == null) {
            return result;
        }
        if (base.isDirectory()) {
            File target = new File(base, "assets/minecraft/" + folder);
            if (target.exists() && target.isDirectory()) {
                Files.walk(target.toPath(), new FileVisitOption[0]).filter(p -> p.toString().endsWith(ext)).forEach(p -> {
                    String relative = base.toPath().relativize((Path)p).toString().replace("\\", "/");
                    result.add(relative.substring("assets/minecraft/".length()));
                });
            }
        } else {
            try (ZipFile zip = new ZipFile(base);){
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith("assets/minecraft/" + folder) || !name.endsWith(ext)) continue;
                    result.add(name.substring("assets/minecraft/".length()));
                }
            }
        }
        return result;
    }

    private File getPackFile(IResourcePack pack) {
        try {
            Field f = AbstractResourcePack.class.getDeclaredField("resourcePackFile");
            f.setAccessible(true);
            return (File)f.get(pack);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

