/*
 * Decompiled with CFR 0.152.
 */
package com.ev.bedrockcaseopening;

import com.ev.bedrockcaseopening.BedrockFloorVII;
import com.ev.bedrockcaseopening.ChestListener;
import com.ev.bedrockcaseopening.DropRarity;
import com.ev.bedrockcaseopening.FloatFontRenderer;
import com.ev.bedrockcaseopening.MyConfig;
import io.netty.util.internal.ThreadLocalRandom;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class CustomDropAnimationGui
extends GuiScreen {
    private Minecraft mc;
    private int scaleFactor;
    private int screenWidth;
    private int screenHeight;
    private int lastScaleFactor = -1;
    private int lastScreenWidth = -1;
    private int lastScreenHeight = -1;
    private float lastSpacing = -1.0f;
    private ResourceLocation alphaFadeSidePNG = new ResourceLocation("bedrockcaseopening", "textures/gui/fade_side.png");
    private ResourceLocation audio = new ResourceLocation("gui.button.press");
    private FloatFontRenderer floatFont;
    Framebuffer frameBufferLayer1;
    Framebuffer frameBufferLayer2;
    Framebuffer guiBuffer;
    private ShaderGroup blurShader;
    private long lastFrameTime = 0L;
    private long guiOpenStartTime = -1L;
    private final List<BedrockFloorVII> carouselItems = new ArrayList<BedrockFloorVII>();
    private BedrockFloorVII rewardItem;
    private final int itemCount = 50;
    private final int rewardSlot = 44;
    private float currentScrollSpeed;
    private float slowTime = MyConfig.slowTime;
    private int slowDistance = MyConfig.slowDistance;
    private int lastBoxDistance = 0;
    private float offsetX = 0.0f;
    private final long animationDuration = 300000000L;
    private float itemBoxWidth;
    private float itemBoxHeight;
    private float itemBoxPadding;
    private float spacing;
    private float centerX;
    private float centerY;
    private float stopPoint;
    private float slowPoint;
    private float randslow;
    private float randstop;
    private boolean hasShownResult = false;

    public CustomDropAnimationGui(BedrockFloorVII rewardItem) {
        if (MyConfig.debugMode) {
            System.out.println("Custom Animation UI Initialize");
        }
        this.mc = Minecraft.func_71410_x();
        this.floatFont = new FloatFontRenderer(this.mc.field_71466_p);
        this.rewardItem = rewardItem;
        this.rewardRandomizer(rewardItem);
        this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)this.audio, (float)1.0f));
        this.randstop = (float)CustomDropAnimationGui.randStopPoint();
        this.randslow = (float)ThreadLocalRandom.current().nextDouble(-2.0, 2.0);
        this.lastFrameTime = System.nanoTime();
        this.guiOpenStartTime = System.nanoTime();
    }

    private void rewardRandomizer(BedrockFloorVII rewardItem) {
        int i;
        ArrayList rarityBuckets = new ArrayList();
        for (int i2 = 0; i2 < 7; ++i2) {
            rarityBuckets.add(new ArrayList());
        }
        for (BedrockFloorVII item : BedrockFloorVII.values()) {
            int rarity = item.getRarityIndex();
            ((List)rarityBuckets.get(rarity - 1)).add(item);
        }
        for (int i3 = 0; i3 < rarityBuckets.size(); ++i3) {
            if (!MyConfig.debugMode) continue;
            System.out.println(((List)rarityBuckets.get(i3)).size());
        }
        int rollsize = 1000;
        ArrayList<Integer> weight = new ArrayList<Integer>();
        ArrayList<Integer> ammount = new ArrayList<Integer>();
        ArrayList<Boolean> checkRepeat = new ArrayList<Boolean>();
        weight.add(2);
        weight.add(4);
        weight.add(10);
        weight.add(20);
        weight.add(100);
        weight.add(100);
        checkRepeat.add(false);
        checkRepeat.add(false);
        checkRepeat.add(false);
        if (rewardItem.getRarityIndex() <= 3) {
            checkRepeat.set(rewardItem.getRarityIndex() - 1, true);
        }
        int rolls = 49;
        for (i = 0; i < 6; ++i) {
            int count = 0;
            if (i < 3 && ((Boolean)checkRepeat.get(i)).booleanValue()) {
                ammount.add(count);
                continue;
            }
            for (int j = 0; j < rolls && (!(Math.random() < (double)((float)((Integer)weight.get(i)).intValue() / (float)rollsize)) || i >= 3 && ++count != ((List)rarityBuckets.get(i)).size()); ++j) {
            }
            ammount.add(count);
            rolls -= count;
        }
        for (i = 6; i >= 0; --i) {
            int j;
            if (i == 6) {
                for (j = 0; j < rolls; ++j) {
                    BedrockFloorVII randomItem = (BedrockFloorVII)((Object)((List)rarityBuckets.get(i)).get(ThreadLocalRandom.current().nextInt(((List)rarityBuckets.get(i)).size())));
                    this.carouselItems.add(randomItem);
                }
                continue;
            }
            if (i < 3 && (Integer)ammount.get(i) > 0) {
                int x = ThreadLocalRandom.current().nextInt(0, 90);
                double randomSlot = (Math.exp(0.04605 * (double)x) * -1.0 + 100.0) / 100.0 * (double)this.carouselItems.size() - 1.0;
                int itemInRarityBucket = ThreadLocalRandom.current().nextInt(((List)rarityBuckets.get(i)).size());
                this.carouselItems.add((int)randomSlot, (BedrockFloorVII)((Object)((List)rarityBuckets.get(i)).get(itemInRarityBucket)));
                if (!MyConfig.debugMode) continue;
                System.out.println("RNG DROP rarity " + i + " at slot " + randomSlot + " x " + x);
                continue;
            }
            for (j = 0; j < (Integer)ammount.get(i); ++j) {
                int randomSlot = ThreadLocalRandom.current().nextInt(this.carouselItems.size() - 1);
                int itemInRarityBucket = ThreadLocalRandom.current().nextInt(((List)rarityBuckets.get(i)).size());
                this.carouselItems.add(randomSlot, (BedrockFloorVII)((Object)((List)rarityBuckets.get(i)).get(itemInRarityBucket)));
                ((List)rarityBuckets.get(i)).remove(itemInRarityBucket);
            }
        }
        this.carouselItems.add(44, rewardItem);
    }

    int getBoxColor(DropRarity rarity) {
        switch (rarity) {
            case PRAYTORNG: {
                return this.getRainbowGlowColor();
            }
            case DIVINE: {
                return -11605013;
            }
            case MYTHIC: {
                return -437255;
            }
            case LEGENDARY: {
                return -1073663;
            }
            case EPIC: {
                return -5635926;
            }
            case FISH: {
                return -11777054;
            }
            case COMMON: {
                return -2039840;
            }
        }
        return -16777216;
    }

    private int getRainbowGlowColor() {
        double time = (double)(System.currentTimeMillis() % 10000L) / 1000.0;
        float hue = (float)time;
        int rgb = Color.HSBtoRGB(hue, 0.6f, 1.0f);
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static double randStopPoint() {
        double rand = ThreadLocalRandom.current().nextDouble(0.0, 100.0);
        if (rand < 40.0) {
            return ThreadLocalRandom.current().nextDouble(0.0, 0.2);
        }
        if (rand < 60.0) {
            return ThreadLocalRandom.current().nextDouble(0.2, 0.8);
        }
        return ThreadLocalRandom.current().nextDouble(0.8, 1.0);
    }

    private double velocityFromX(double x, float scaleFactor) {
        double X = this.stopPoint - this.slowPoint;
        double T = this.slowTime;
        if (x <= 0.0) {
            double v0 = X * 3.0 / T;
            return v0;
        }
        if (x >= X) {
            return 0.0;
        }
        double normX = x / X;
        double t = T * (1.0 - Math.cbrt(1.0 - normX));
        double nt = t / T;
        return X * 3.0 * Math.pow(1.0 - nt, 2.0) / T;
    }

    private void updateLayout(ScaledResolution scaled) {
        this.itemBoxWidth = (float)this.screenWidth / 5.0f;
        this.itemBoxHeight = (float)this.screenHeight / 4.0f;
        this.itemBoxPadding = (float)this.screenWidth / 64.0f;
        this.spacing = this.itemBoxWidth + this.itemBoxPadding;
        if (this.lastSpacing > 0.0f) {
            float ratio = this.spacing / this.lastSpacing;
            this.offsetX *= ratio;
        }
        this.lastSpacing = this.spacing;
        this.lastScaleFactor = this.scaleFactor;
        this.lastScreenWidth = this.screenWidth;
        this.lastScreenHeight = this.screenHeight;
        this.centerX = this.screenWidth / 2;
        this.centerY = this.screenHeight / 2;
        this.stopPoint = 41.0f * this.spacing + this.randstop * this.itemBoxWidth;
        this.slowPoint = this.stopPoint - ((float)this.slowDistance + this.randslow) * this.spacing;
        this.frameBufferLayer1 = new Framebuffer(this.screenWidth, this.screenHeight, true);
        this.frameBufferLayer2 = new Framebuffer(this.screenWidth, this.screenHeight, true);
        this.guiBuffer = new Framebuffer(this.screenWidth, this.screenHeight, true);
        GL11.glPushMatrix();
        GL11.glScalef((float)(1.0f / (float)this.scaleFactor), (float)(1.0f / (float)this.scaleFactor), (float)1.0f);
        this.setupStencilLayer1();
        this.setupStencilLayer2();
        GL11.glPopMatrix();
        if (this.blurShader != null) {
            this.blurShader.func_148026_a(this.mc.field_71443_c, this.mc.field_71440_d);
        }
        if (MyConfig.debugMode) {
            System.out.println("[DEBUG] Resolution changed \u2192 New scaleFactor=" + this.scaleFactor + ", width=" + this.screenWidth + ", height=" + this.screenHeight);
        }
        if (MyConfig.debugMode) {
            System.out.println("[DEBUG] Resolution changed \u2192 MC.window" + this.mc.field_71443_c + " x " + this.mc.field_71440_d);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.mc.field_71460_t != null && this.mc.func_147110_a() != null) {
            try {
                this.blurShader = new ShaderGroup(this.mc.func_110434_K(), this.mc.func_110442_L(), this.mc.func_147110_a(), new ResourceLocation("bedrockcaseopening", "shaders/post/blur.json"));
                this.blurShader.func_148026_a(this.mc.field_71443_c, this.mc.field_71440_d);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179118_c();
        float progress = (float)(System.nanoTime() - this.guiOpenStartTime) / 3.0E8f;
        progress = Math.min(progress, 1.0f);
        progress = 1.0f - (1.0f - progress) * (1.0f - progress);
        ScaledResolution scaled = new ScaledResolution(this.mc);
        this.scaleFactor = scaled.func_78325_e();
        this.screenWidth = scaled.func_78326_a() * this.scaleFactor;
        this.screenHeight = scaled.func_78328_b() * this.scaleFactor;
        if (this.scaleFactor != this.lastScaleFactor || this.screenWidth != this.lastScreenWidth || this.screenHeight != this.lastScreenHeight) {
            this.updateLayout(scaled);
        }
        long now = System.nanoTime();
        if (this.lastFrameTime == 0L) {
            this.lastFrameTime = now;
        }
        float deltaTime = (float)(now - this.lastFrameTime) / 1.0E9f;
        deltaTime = Math.min(deltaTime, 0.05f);
        this.lastFrameTime = now;
        if (!this.hasShownResult) {
            this.currentScrollSpeed = (float)this.velocityFromX(this.offsetX - this.slowPoint, this.scaleFactor);
            this.offsetX += this.currentScrollSpeed * deltaTime;
            if (this.currentScrollSpeed == 0.0f) {
                this.hasShownResult = true;
            }
        }
        if (this.hasShownResult) {
            String sound;
            switch (this.rewardItem.getRarity().getIndex()) {
                case 7: {
                    sound = "dig.grass";
                    break;
                }
                case 6: {
                    sound = "liquid.splash";
                    break;
                }
                case 5: {
                    sound = "random.orb";
                    break;
                }
                case 4: {
                    sound = "fireworks.launch";
                    break;
                }
                case 3: {
                    sound = "random.levelup";
                    break;
                }
                case 2: {
                    sound = "mob.wither.spawn";
                    break;
                }
                case 1: {
                    sound = "random.levelup";
                    break;
                }
                default: {
                    return;
                }
            }
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("minecraft", sound), (float)1.0f));
            if (this.rewardItem.getRarity().getIndex() == 1) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("minecraft", "fireworks.launch"), (float)1.0f));
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("minecraft", "mob.wither.spawn"), (float)1.0f));
            }
            Minecraft.func_71410_x().func_147108_a((GuiScreen)ChestListener.originalGui);
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)(1.0f / (float)this.scaleFactor), (float)(1.0f / (float)this.scaleFactor), (float)1.0f);
        this.renderLayer1(progress);
        this.blurShader.func_148018_a(partialTicks);
        this.renderLayer2(progress);
        this.renderJudgementLine();
        GL11.glPopMatrix();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void setupStencilLayer1() {
        this.frameBufferLayer1.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        this.frameBufferLayer1.enableStencil();
        this.frameBufferLayer1.func_147610_a(true);
        GL11.glClear((int)17664);
        GL11.glEnable((int)2960);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glStencilFunc((int)519, (int)1, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
        GL11.glStencilMask((int)255);
        this.drawCircleAlphaMask(this.centerX, this.centerY, this.centerY * 2.0f / 3.0f, -1, 64);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDisable((int)2960);
    }

    public void renderLayer1(float progress) {
        this.frameBufferLayer1.func_147610_a(true);
        GL11.glClear((int)16640);
        GL11.glEnable((int)2960);
        GL11.glStencilFunc((int)517, (int)1, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glStencilMask((int)0);
        float scale = progress;
        this.drawCarousel(this.centerX, this.centerY, scale * 0.8f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)0, (int)771);
        this.mc.func_110434_K().func_110577_a(this.alphaFadeSidePNG);
        Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)1920, (int)1080, (float)this.screenWidth, (float)this.screenHeight);
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2960);
        this.mc.func_147110_a().func_147610_a(true);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        this.frameBufferLayer1.func_178038_a(this.screenWidth, this.screenHeight, false);
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void setupStencilLayer2() {
        this.frameBufferLayer2.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        this.frameBufferLayer2.enableStencil();
        this.frameBufferLayer2.func_147610_a(true);
        GL11.glClear((int)17664);
        GL11.glEnable((int)2960);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glStencilFunc((int)519, (int)1, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
        GL11.glStencilMask((int)255);
        this.drawCircleAlphaMask(this.centerX, this.centerY, this.centerY * 2.0f / 3.0f, -1, 64);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDisable((int)2960);
    }

    public void renderLayer2(float progress) {
        this.frameBufferLayer2.func_147610_a(true);
        GL11.glClear((int)16640);
        GL11.glEnable((int)2960);
        GL11.glStencilFunc((int)514, (int)1, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glStencilMask((int)0);
        GlStateManager.func_179094_E();
        float scale = progress;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawCircleAlphaMask(this.centerX, this.centerY, this.centerY * 2.0f / 3.0f * scale, 0x3F000000, 64);
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawCarousel(this.centerX, this.centerY, 1.0f * scale);
        GlStateManager.func_179121_F();
        GL11.glDisable((int)2960);
        this.mc.func_147110_a().func_147610_a(true);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        this.frameBufferLayer2.func_178038_a(this.screenWidth, this.screenHeight, false);
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawCarousel(float centerX, float centerY, float size) {
        for (int i = 0; i < this.carouselItems.size(); ++i) {
            DropRarity rarity;
            float x = centerX - (this.offsetX - (float)(i - 3) * this.spacing) * size;
            float y = centerY - this.itemBoxHeight / 2.0f * size;
            if (x + this.itemBoxWidth < 0.0f || x > (float)this.screenWidth || y + this.itemBoxHeight < 0.0f || y > (float)this.screenHeight || (rarity = this.carouselItems.get(i).getRarity()) == null) continue;
            int boxColor = this.getBoxColor(rarity);
            float y1 = y + this.itemBoxHeight * size * 15.0f / 16.0f;
            float y2 = y + this.itemBoxHeight * size;
            float textX = x + this.itemBoxWidth * 1.0f / 2.0f;
            float textY = y + this.itemBoxHeight * 3.0f / 4.0f;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            CustomDropAnimationGui.func_73734_a((int)((int)x), (int)((int)y), (int)((int)(x + this.itemBoxWidth * size)), (int)((int)(y + this.itemBoxHeight * size)), (int)0x3F888888);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            CustomDropAnimationGui.func_73734_a((int)((int)x), (int)((int)y1), (int)((int)(x + this.itemBoxWidth * size)), (int)((int)y2), (int)boxColor);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73733_a((int)x, (int)(y2 - this.itemBoxHeight * size), (int)(x + this.itemBoxWidth * size), (int)y2, boxColor & 0xFFFFFF | 0, boxColor & 0xFFFFFF | 0xCC000000);
            GlStateManager.func_179084_k();
            this.renderImage(i, x, y, size);
            if (!MyConfig.allowText) continue;
            GL11.glPushMatrix();
            GL11.glScalef((float)MyConfig.textScale, (float)MyConfig.textScale, (float)1.0f);
            this.floatFont.drawCenteredString(this.normalizeString(this.carouselItems.get(i).name()), textX / MyConfig.textScale, textY / MyConfig.textScale, boxColor, true);
            GL11.glPopMatrix();
        }
    }

    public String normalizeString(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        String[] parts = input.split("_");
        StringBuilder result = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            String word = part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase();
            result.append(word).append(" ");
        }
        return result.toString().trim();
    }

    public void renderJudgementLine() {
        float lineWidth = this.screenWidth / 512;
        float lineHeight = this.screenHeight / 4;
        CustomDropAnimationGui.func_73734_a((int)((int)(this.centerX - lineWidth / 2.0f)), (int)((int)((double)this.centerY - (double)(lineHeight / 3.0f) * 2.5)), (int)((int)(this.centerX + lineWidth)), (int)((int)(this.centerY + lineHeight)), (int)-23296);
        int boxDistance = (int)this.offsetX % (int)this.spacing;
        if (boxDistance < this.lastBoxDistance) {
            this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)this.audio, (float)1.0f));
        }
        this.lastBoxDistance = boxDistance;
    }

    public void renderImage(int slot, float currentX, float currentY, float size) {
        ResourceLocation image = this.carouselItems.get(slot).getImage();
        int frameCount = this.carouselItems.get(slot).getFrameCount();
        int frameHeight = 16;
        float frameDurationMs = this.carouselItems.get(slot).getFrameTick() * 50;
        long time = System.currentTimeMillis() % 10000L;
        int frameIndex = (int)((long)((float)time / frameDurationMs) % (long)frameCount);
        float v = frameIndex * frameHeight;
        if (image != null) {
            int imageWidth = 16;
            int imageHeight = 16;
            float imageSize = 0.8f * this.itemBoxHeight * size;
            float imageX = currentX + this.itemBoxWidth * size / 2.0f - imageSize / 2.0f;
            float imageY = currentY + this.itemBoxHeight * size / 2.0f - imageSize / 2.0f;
            try {
                this.mc.func_110434_K().func_110577_a(image);
            }
            catch (Exception e) {
                if (MyConfig.debugMode) {
                    System.out.println(e);
                }
                this.mc.func_110434_K().func_110577_a(TextureMap.field_174945_f);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            CustomDropAnimationGui.func_152125_a((int)((int)imageX), (int)((int)imageY), (float)0.0f, (float)v, (int)imageWidth, (int)imageHeight, (int)((int)imageSize), (int)((int)imageSize), (float)16.0f, (float)(frameHeight * frameCount));
        }
    }

    public void drawCircleAlphaMask(float centerX, float centerY, float radius, int color, int segments) {
        if (segments < 3) {
            segments = 32;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        GL11.glDisable((int)2884);
        GL11.glBegin((int)6);
        GL11.glVertex2f((float)centerX, (float)centerY);
        for (int i = 0; i <= segments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)segments;
            float x = (float)((double)centerX + Math.cos(angle) * (double)radius);
            float y = (float)((double)centerY + Math.sin(angle) * (double)radius);
            GL11.glVertex2f((float)x, (float)y);
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        if (this.mc.field_71460_t != null) {
            this.mc.field_71460_t.func_181022_b();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)ChestListener.originalGui);
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }
}

