/*
 * Decompiled with CFR 0.152.
 */
package com.ev.bedrockcaseopening;

import com.ev.bedrockcaseopening.MyConfig;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class NBTUtils {
    public static void printAllNBT(ItemStack stack) {
        if (stack == null) {
            if (MyConfig.debugMode) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("STACK NULL"));
            }
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            if (MyConfig.debugMode) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("NO NBT"));
            }
            return;
        }
        NBTUtils.printCompound(tag, 0);
    }

    private static void printCompound(NBTTagCompound compound, int indent) {
        Set keys = compound.func_150296_c();
        String pad = new String(new char[indent]).replace("\u0000", "  ");
        for (String key : keys) {
            NBTBase base = compound.func_74781_a(key);
            if (key == "textures") break;
            byte type = base.func_74732_a();
            if (type == 10) {
                if (MyConfig.debugMode) {
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(pad + key + ": {"));
                }
                NBTUtils.printCompound((NBTTagCompound)base, indent + 1);
                if (!MyConfig.debugMode) continue;
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(pad + "}"));
                continue;
            }
            if (!MyConfig.debugMode) continue;
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(pad + key + " = " + base.toString()));
        }
    }

    public static String getExtraAttributeId(ItemStack stack) {
        if (stack == null) {
            return "STACKNULL";
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return "TAGNULL";
        }
        if (!tag.func_74764_b("ExtraAttributes")) {
            return "KEYNULL";
        }
        NBTTagCompound extra = tag.func_74775_l("ExtraAttributes");
        if (!extra.func_74764_b("id")) {
            return "IDNULL";
        }
        String id = extra.func_74779_i("id");
        if ("ENCHANTED_BOOK".equalsIgnoreCase(id) && extra.func_74764_b("enchantments")) {
            NBTTagCompound enchants = extra.func_74775_l("enchantments");
            Iterator iterator = enchants.func_150296_c().iterator();
            if (iterator.hasNext()) {
                String key = (String)iterator.next();
                int level = enchants.func_74762_e(key);
                return key + "_" + level;
            }
            return "ENCHNULL";
        }
        return id;
    }
}

