/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade;

import com.github.iunius118.tolaserblade.api.ToLaserBladeAPI;
import com.github.iunius118.tolaserblade.client.ClientModEventHandler;
import com.github.iunius118.tolaserblade.client.model.LaserBladeModelManager;
import com.github.iunius118.tolaserblade.common.CommonEventHandler;
import com.github.iunius118.tolaserblade.common.RegistryEventHandler;
import com.github.iunius118.tolaserblade.config.TLBClientConfig;
import com.github.iunius118.tolaserblade.config.TLBServerConfig;
import com.github.iunius118.tolaserblade.data.TLBDataGenerator;
import com.github.iunius118.tolaserblade.data.TLBOldRecipeProvider6;
import com.github.iunius118.tolaserblade.data.TLBSampleSoundPackProvider;
import com.github.iunius118.tolaserblade.world.item.ItemEventHandler;
import com.github.iunius118.tolaserblade.world.item.ModCreativeModeTabs;
import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;

@Mod(value="tolaserblade")
public class ToLaserBlade {
    public static final String MOD_ID = "tolaserblade";
    public static final String MOD_NAME = "ToLaserBlade";
    public static final Logger LOGGER = LogUtils.getLogger();

    public ToLaserBlade(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)TLBServerConfig.SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)TLBClientConfig.SPEC);
        modEventBus.addListener(TLBServerConfig::onLoad);
        modEventBus.addListener(TLBClientConfig::onLoad);
        RegistryEventHandler.registerGameObjects(modEventBus);
        modEventBus.addListener(TLBDataGenerator::gatherData);
        modEventBus.addListener(ModCreativeModeTabs::onCreativeModeTabBuildContents);
        modEventBus.addListener(TLBOldRecipeProvider6::addPackFinders);
        modEventBus.addListener(TLBSampleSoundPackProvider::addPackFinders);
        NeoForge.EVENT_BUS.register(CommonEventHandler.class);
        NeoForge.EVENT_BUS.register(ItemEventHandler.class);
        if (FMLEnvironment.getDist().isClient()) {
            modEventBus.register(ClientModEventHandler.class);
            ToLaserBladeAPI.registerModelRegistrationListener(event -> event.register(LaserBladeModelManager.loadModels()));
        }
    }

    public static ResourceLocation makeId(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }
}

