/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client;

import com.github.iunius118.tolaserblade.ToLaserBlade;
import com.github.iunius118.tolaserblade.client.color.item.LaserBladeTintSource;
import com.github.iunius118.tolaserblade.client.extensions.LBSwordItemExtensions;
import com.github.iunius118.tolaserblade.client.model.LaserBladeModelManager;
import com.github.iunius118.tolaserblade.client.particle.LaserTrapParticle;
import com.github.iunius118.tolaserblade.client.particle.LaserTrapParticleGroup;
import com.github.iunius118.tolaserblade.client.renderer.LaserBladePipelines;
import com.github.iunius118.tolaserblade.client.renderer.item.LBSwordSpecialRenderer;
import com.github.iunius118.tolaserblade.client.renderer.item.properties.Blocking;
import com.github.iunius118.tolaserblade.client.renderer.item.properties.UsingOriginalModel;
import com.github.iunius118.tolaserblade.core.particle.ModParticleTypes;
import com.github.iunius118.tolaserblade.world.item.ModItems;
import java.net.URI;
import java.net.URL;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.VersionChecker;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterConditionalItemModelPropertyEvent;
import net.neoforged.neoforge.client.event.RegisterParticleGroupsEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterRenderPipelinesEvent;
import net.neoforged.neoforge.client.event.RegisterSpecialModelRendererEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforgespi.language.IModInfo;

public class ClientModEventHandler {
    @SubscribeEvent
    public static void onRegisterItemTintSourceEvent(RegisterColorHandlersEvent.ItemTintSources event) {
        event.register(ToLaserBlade.makeId("laser_blade"), LaserBladeTintSource.MAP_CODEC);
    }

    @SubscribeEvent
    public static void onRegisterConditionalItemModelPropertyEvent(RegisterConditionalItemModelPropertyEvent event) {
        event.register(ToLaserBlade.makeId("using_original_model"), UsingOriginalModel.MAP_CODEC);
        event.register(ToLaserBlade.makeId("blocking"), Blocking.MAP_CODEC);
    }

    @SubscribeEvent
    public static void onModifyBakingResultEvent(ModelEvent.ModifyBakingResult event) {
        LaserBladeModelManager.getInstance().reload();
    }

    @SubscribeEvent
    public static void onBakingCompletedEvent(ModelEvent.BakingCompleted event) {
        LaserBladeModelManager.getInstance().logLoadedModelCount();
    }

    @SubscribeEvent
    public static void onRegisterSpecialModelRendererEvent(RegisterSpecialModelRendererEvent event) {
        event.register(ToLaserBlade.makeId("laser_blade"), LBSwordSpecialRenderer.Unbaked.MAP_CODEC);
    }

    @SubscribeEvent
    public static void onRegisterClientExtensionsEvent(RegisterClientExtensionsEvent event) {
        event.registerItem((IClientItemExtensions)new LBSwordItemExtensions(), new Item[]{ModItems.LASER_BLADE, ModItems.LASER_BLADE_FP});
    }

    @SubscribeEvent
    public static void onParticleFactoryRegisterEvent(RegisterParticleProvidersEvent event) {
        event.registerSpecial((ParticleType)ModParticleTypes.LASER_TRAP_X, (ParticleProvider)new LaserTrapParticle.Provider(Direction.Axis.X));
        event.registerSpecial((ParticleType)ModParticleTypes.LASER_TRAP_Y, (ParticleProvider)new LaserTrapParticle.Provider(Direction.Axis.Y));
        event.registerSpecial((ParticleType)ModParticleTypes.LASER_TRAP_Z, (ParticleProvider)new LaserTrapParticle.Provider(Direction.Axis.Z));
    }

    @SubscribeEvent
    public static void onRegisterParticleGroupsEvent(RegisterParticleGroupsEvent event) {
        event.register(LaserTrapParticle.PARTICLE_RENDER_TYPE, LaserTrapParticleGroup::new);
    }

    @SubscribeEvent
    public static void onRegisterRenderPipelinesEvent(RegisterRenderPipelinesEvent event) {
        LaserBladePipelines.onRegisterRenderPipelinesEvent(event);
    }

    public static void checkUpdate() {
        VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)((IModInfo)ModList.get().getModFileById("tolaserblade").getMods().getFirst()));
        try {
            URI uri = new URL(result.url()).toURI();
            VersionChecker.Status status = result.status();
            if (status == VersionChecker.Status.PENDING || result.target() == null) {
                return;
            }
            if (status == VersionChecker.Status.OUTDATED || status == VersionChecker.Status.BETA_OUTDATED) {
                MutableComponent modNameHighlighted = Component.literal((String)"ToLaserBlade").withStyle(ChatFormatting.YELLOW);
                MutableComponent newVersionHighlighted = Component.literal((String)result.target().toString()).withStyle(ChatFormatting.YELLOW);
                MutableComponent message = Component.translatable((String)"tolaserblade.update.newVersion", (Object[])new Object[]{modNameHighlighted}).append(": ").append((Component)newVersionHighlighted).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(uri)));
                Minecraft.getInstance().gui.getChat().addMessage((Component)message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static ResourceLocation getItemId(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }
}

