/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client.color.item;

import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeAppearance;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeColor;
import com.github.iunius118.tolaserblade.world.item.LBBrandNewItem;
import com.github.iunius118.tolaserblade.world.item.LBBrokenItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record LaserBladeItemColor(boolean isBroken, int type, int outerColor, boolean isOuterSubColor, int innerColor, boolean isInnerSubColor, int gripColor) {
    public static final LaserBladeItemColor DEFAULT = new LaserBladeItemColor(false, 0, -1, false, -1, false, -1);

    public static LaserBladeItemColor of(ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            return DEFAULT;
        }
        Item item = itemStack.getItem();
        boolean isBroken = item instanceof LBBrokenItem || item instanceof LBBrandNewItem;
        LaserBladeAppearance appearance = LaserBladeAppearance.of(itemStack);
        int type = appearance.getType();
        int rawOuterColor = appearance.getOuterColor();
        int outerColor = LaserBladeItemColor.checkGamingColor(rawOuterColor);
        boolean isOuterSubColor = appearance.isOuterSubColor();
        int rawInnerColor = appearance.getInnerColor();
        int innerColor = LaserBladeItemColor.checkGamingColor(rawInnerColor);
        boolean isInnerSubColor = appearance.isInnerSubColor();
        int rawGripColor = appearance.getGripColor();
        int gripColor = LaserBladeItemColor.checkGamingColor(rawGripColor);
        return new LaserBladeItemColor(isBroken, type, outerColor, isOuterSubColor, innerColor, isInnerSubColor, gripColor);
    }

    public int outerColor(boolean isGUI) {
        return isGUI ? this.guiOuterColor() : this.outerColor();
    }

    public int innerColor(boolean isGUI) {
        return isGUI ? this.guiInnerColor() : this.innerColor();
    }

    public int gripColor(boolean isGUI) {
        return this.gripColor();
    }

    public int guiOuterColor() {
        return !this.isOuterSubColor ? this.outerColor : ~(this.outerColor & 0xFFFFFF) | this.outerColor & 0xFF000000;
    }

    public int guiInnerColor() {
        return !this.isInnerSubColor ? this.innerColor : ~(this.innerColor & 0xFFFFFF) | this.innerColor & 0xFF000000;
    }

    public int simpleOuterColor(boolean isGUI) {
        return this.simpleOuterColor();
    }

    public int simpleInnerColor(boolean isGUI) {
        return this.simpleInnerColor();
    }

    public int simpleGripColor(boolean isGUI) {
        return this.simpleGripColor();
    }

    public int simpleOuterColor() {
        return (this.isOuterSubColor ? ~this.outerColor : this.outerColor) | 0xFF000000;
    }

    public int simpleInnerColor() {
        return (this.isInnerSubColor ? ~this.innerColor : this.innerColor) | 0xFF000000;
    }

    public int simpleGripColor() {
        return this.gripColor | 0xFF000000;
    }

    private static int checkGamingColor(int color) {
        if (color == LaserBladeColor.SPECIAL_GAMING.getOuterColor()) {
            return LaserBladeItemColor.getGamingColor();
        }
        return color;
    }

    private static int getGamingColor() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player != null) {
            float partialTick = minecraft.getDeltaTracker().getGameTimeDeltaPartialTick(true);
            Level level = player.level();
            int tick1 = (int)(level.getGameTime() % 30L);
            int tick2 = tick1 % 10;
            if (tick2 % 10 < 5) {
                int colorElement = (int)(((float)tick2 + partialTick) * 51.0f) & 0xFF;
                return switch (tick1 / 10) {
                    case 0 -> 0xFFFF0000 | colorElement << 8;
                    case 1 -> 0xFF00FF00 | colorElement;
                    default -> 0xFF0000FF | colorElement << 16;
                };
            }
            int colorElement = (int)(((float)(10 - tick2) - partialTick) * 51.0f) & 0xFF;
            return switch (tick1 / 10) {
                case 0 -> 0xFF00FF00 | colorElement << 16;
                case 1 -> 0xFF0000FF | colorElement << 8;
                default -> 0xFFFF0000 | colorElement;
            };
        }
        return -16711423;
    }
}

