/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client.model;

import com.github.iunius118.tolaserblade.ToLaserBlade;
import com.github.iunius118.tolaserblade.api.client.event.LaserBladeModelRegistrationEvent;
import com.github.iunius118.tolaserblade.api.client.model.LaserBladeModel;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeJsonModelLoader;
import com.github.iunius118.tolaserblade.client.model.laserblade.v1.LaserBladeModelV1;
import com.github.iunius118.tolaserblade.config.TLBClientConfig;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeAppearance;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.BusBuilder;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import org.slf4j.Logger;

public class LaserBladeModelManager {
    public static final IEventBus EVENT_BUS = BusBuilder.builder().build();
    private static final Logger LOGGER = ToLaserBlade.LOGGER;
    private static final String MODEL_DIR = "models/item/laser_blade";
    private static final LaserBladeModelManager INSTANCE = new LaserBladeModelManager();
    private Map<Integer, LaserBladeModel> models = Collections.emptyMap();
    private LaserBladeModel defaultModel;
    private boolean canUseOriginalModelType;
    private boolean canUseMultipleModels;

    private LaserBladeModelManager() {
    }

    public static LaserBladeModelManager getInstance() {
        return INSTANCE;
    }

    public static List<LaserBladeModel> loadModels() {
        return LaserBladeModelManager.parseJsonModels();
    }

    public void reload() {
        this.canUseOriginalModelType = TLBClientConfig.useOriginalModelType;
        this.canUseMultipleModels = TLBClientConfig.renderMultipleModels;
        if (!this.canUseOriginalModelType) {
            this.models = Collections.emptyMap();
            this.defaultModel = null;
            return;
        }
        this.models = new HashMap<Integer, LaserBladeModel>();
        EVENT_BUS.post((Event)new LaserBladeModelRegistrationEvent(models -> models.forEach(this::addModel)));
        int defaultModelNumber = TLBClientConfig.defaultModel;
        this.defaultModel = this.models.containsKey(defaultModelNumber) ? this.models.get(defaultModelNumber) : this.models.get(0);
        LaserBladeModelV1.resetRenderTypes();
    }

    public void logLoadedModelCount() {
        int count = this.models.size();
        if (count == 1) {
            LOGGER.info("1 model has been loaded as a laser blade model");
        } else {
            LOGGER.info("{} models have been loaded as laser blade models", (Object)count);
        }
    }

    private static List<LaserBladeModel> parseJsonModels() {
        Map<ResourceLocation, Resource> resourceMap = LaserBladeModelManager.findJsonFiles();
        LinkedList<LaserBladeModel> jsonModels = new LinkedList<LaserBladeModel>();
        resourceMap.forEach((location, resource) -> {
            LaserBladeModel model = LaserBladeJsonModelLoader.parse(location.toString(), resource);
            if (model != null) {
                jsonModels.add(model);
            }
        });
        return jsonModels;
    }

    private static Map<ResourceLocation, Resource> findJsonFiles() {
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        return resourceManager.listResources(MODEL_DIR, resourceLocation -> {
            String namespace = resourceLocation.getNamespace();
            String path = resourceLocation.getPath();
            return namespace.equals("tolaserblade") && path.endsWith(".json");
        });
    }

    public boolean canUseOriginalModelType() {
        return this.canUseOriginalModelType;
    }

    public boolean canUseMultipleModels() {
        return this.canUseMultipleModels;
    }

    public void addModel(LaserBladeModel model) {
        if (model == null) {
            ToLaserBlade.LOGGER.warn("[ToLaserBlade] Attempted to add null as Laser Blade model.");
            return;
        }
        int index = model.getID();
        if (index < 0) {
            ToLaserBlade.LOGGER.warn("[ToLaserBlade] Attempted to add a model to invalid index {}.", (Object)index);
            return;
        }
        if (this.models.containsKey(index)) {
            ToLaserBlade.LOGGER.info("[ToLaserBlade] Laser Blade model #{} already exists. It will be overwritten.", (Object)index);
        }
        this.models.put(index, model);
    }

    public LaserBladeModel getModel() {
        return this.defaultModel;
    }

    public LaserBladeModel getModel(ItemStack itemStack) {
        if (this.canUseMultipleModels) {
            int type = LaserBladeAppearance.of(itemStack).getType();
            LaserBladeModel model = this.getModel(type);
            if (model != null) {
                return model;
            }
            return this.defaultModel;
        }
        return this.defaultModel;
    }

    public LaserBladeModel getModel(int modelID) {
        if (this.canUseMultipleModels) {
            LaserBladeModel model = this.models.get(modelID);
            if (model != null) {
                return model;
            }
            return this.defaultModel;
        }
        return this.defaultModel;
    }

    public Map<Integer, LaserBladeModel> getModels() {
        return this.models;
    }
}

