/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client.model.laserblade.v1;

import com.github.iunius118.tolaserblade.ToLaserBlade;
import com.github.iunius118.tolaserblade.api.client.model.LaserBladeModel;
import com.github.iunius118.tolaserblade.client.color.item.LaserBladeItemColor;
import com.github.iunius118.tolaserblade.client.model.SimpleLaserBladeModel;
import com.github.iunius118.tolaserblade.client.model.laserblade.v1.ModelObject;
import com.github.iunius118.tolaserblade.client.model.laserblade.v1.ModelParser;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.Reader;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public class LaserBladeModelV1
extends SimpleLaserBladeModel {
    public static final String MODEL_TYPE = "tolaserblade:model_v1";
    private static final ResourceLocation TEXTURE = ToLaserBlade.makeId("textures/item/laser_blade_3d.png");
    private final List<ModelObject> modelObjects;
    private final String name;
    private final int id;
    private final Vector3f guiResize;

    public static LaserBladeModel parseModel(String modelName, Reader resourceReader) {
        return ModelParser.parse(modelName, resourceReader);
    }

    public static void resetRenderTypes() {
        LaserBladeModelV1.resetRenderTypes(TEXTURE);
    }

    LaserBladeModelV1(String modelName, int modelID, Vector3f resizeInGUI, List<ModelObject> modelObjectList) {
        this.name = modelName;
        this.id = modelID;
        this.guiResize = resizeInGUI;
        this.modelObjects = modelObjectList;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void submit(ItemStack itemStack, ItemDisplayContext mode, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int light, int overlay) {
        boolean isGUI;
        boolean bl = isGUI = mode == ItemDisplayContext.GUI;
        if (this.guiResize != null && (isGUI || mode == ItemDisplayContext.FIXED || mode == ItemDisplayContext.ON_SHELF)) {
            poseStack.translate(0.0f, this.guiResize.y(), this.guiResize.z());
            if (mode != ItemDisplayContext.ON_SHELF) {
                float size = this.guiResize.x();
                poseStack.scale(size, size, size);
            }
        }
        if (mode == ItemDisplayContext.ON_SHELF) {
            poseStack.translate(0.0f, 0.375f, -0.375f);
        }
        LaserBladeItemColor laserBladeItemColor = LaserBladeItemColor.of(itemStack);
        ModelObject.RenderingContext renderingContext = new ModelObject.RenderingContext(itemStack, mode, poseStack);
        int order = 0;
        int pushCount = 0;
        for (ModelObject modelObject : this.modelObjects) {
            if (!modelObject.isAvailable(laserBladeItemColor.isBroken())) continue;
            if (modelObject.isFunction) {
                pushCount = modelObject.function.invoke(renderingContext, pushCount);
                continue;
            }
            RenderType renderType = modelObject.renderType.get(this, laserBladeItemColor, isGUI);
            int color = modelObject.color.get(laserBladeItemColor, isGUI);
            int lightColorCoordinate = modelObject.getLightColor(light);
            this.renderQuads(poseStack, submitNodeCollector, order, renderType, modelObject.quads, color, lightColorCoordinate, overlay);
            ++order;
        }
        for (int i = pushCount; i > 0; --i) {
            poseStack.popPose();
        }
    }
}

