/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client.model.laserblade.v1;

import com.github.iunius118.tolaserblade.client.color.item.LaserBladeItemColor;
import com.github.iunius118.tolaserblade.client.model.SimpleLaserBladeModel;
import com.github.iunius118.tolaserblade.client.model.SimpleModel;
import com.github.iunius118.tolaserblade.client.model.Vector2f;
import com.github.iunius118.tolaserblade.client.model.laserblade.v1.JsonModelV1;
import com.github.iunius118.tolaserblade.client.model.laserblade.v1.ModelObjectFunctions;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModelObject {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ToLaserBlade.LaserBladeModelVersion1.ModelObject");
    private static final Vector2f FIXED_UV = new Vector2f(0.0f, 0.0f);
    private static final int WHITE_ARGB = -1;
    private static final int GRAY_ARGB = -3355444;
    private static final int UNLIT_LIGHT = 0xF000F0;
    private final JsonModelV1.JsonModelObject.State state;
    private final boolean isUnlitLight;
    public final boolean isFunction;
    public final ModelObjectFunction function;
    public final ObjectRenderType renderType;
    public final ObjectPartColor color;
    public final List<SimpleModel.SimpleQuad> quads = new ArrayList<SimpleModel.SimpleQuad>();
    private static final ObjectRenderType ADD_INNER_TYPE = (model, itemColor, isGUI) -> model.getInnerBladeAddRenderType(itemColor.isInnerSubColor(), isGUI);
    private static final ObjectRenderType ADD_OUTER_TYPE = (model, itemColor, isGUI) -> model.getOuterBladeAddRenderType(itemColor.isOuterSubColor(), isGUI);
    private static final ObjectRenderType UNLIT_TYPE = (model, itemColor, isGUI) -> model.getUnlitRenderType();
    private static final ObjectRenderType HILT_TYPE = (model, itemColor, isGUI) -> model.getHiltRenderType();
    private static final ObjectPartColor GRIP_COLOR = LaserBladeItemColor::gripColor;
    private static final ObjectPartColor INNER_COLOR = LaserBladeItemColor::innerColor;
    private static final ObjectPartColor SIMPLE_INNER_COLOR = LaserBladeItemColor::simpleInnerColor;
    private static final ObjectPartColor OUTER_COLOR = LaserBladeItemColor::outerColor;
    private static final ObjectPartColor SIMPLE_OUTER_COLOR = LaserBladeItemColor::simpleOuterColor;
    private static final ObjectPartColor DEFAULT_COLOR = (itemColor, isGUI) -> -1;
    private static final ObjectPartColor OFF_COLOR = (itemColor, isGUI) -> -3355444;

    public ModelObject(String objectName, JsonModelV1.JsonModelObject object, List<Vector3f> vertices, List<Vector4f> colors, List<Vector3f> normals, List<int[]> faces) {
        JsonModelV1.JsonModelObject.Type type = object.type;
        JsonModelV1.JsonModelObject.Part part = object.part;
        this.state = object.state;
        this.isFunction = type == JsonModelV1.JsonModelObject.Type.FUNCTION;
        this.function = this.getObjectFunction(object);
        this.renderType = this.getRenderType(type, part);
        this.color = this.getPartColor(type, part);
        this.isUnlitLight = this.isUnlitLight(type);
        if (!this.isFunction) {
            this.initQuads(objectName, vertices, colors, normals, faces, object);
        }
    }

    public boolean isAvailable(boolean isBroken) {
        return this.state == JsonModelV1.JsonModelObject.State.ANY || !isBroken && this.state == JsonModelV1.JsonModelObject.State.ONLY_WORKING || isBroken && this.state == JsonModelV1.JsonModelObject.State.ONLY_BROKEN;
    }

    private ModelObjectFunction getObjectFunction(JsonModelV1.JsonModelObject object) {
        if (object.type == JsonModelV1.JsonModelObject.Type.FUNCTION) {
            return switch (object.name) {
                case "rotate" -> ModelObjectFunctions.FN_ROTATE;
                case "shield" -> ModelObjectFunctions.FN_SHIELD;
                case "pop_pose" -> ModelObjectFunctions.FN_POP_POSE;
                default -> ModelObjectFunctions.FN_NOP;
            };
        }
        return ModelObjectFunctions.FN_NOP;
    }

    private ObjectRenderType getRenderType(JsonModelV1.JsonModelObject.Type type, JsonModelV1.JsonModelObject.Part part) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case JsonModelV1.JsonModelObject.Type.ADD -> {
                if (part == JsonModelV1.JsonModelObject.Part.BLADE_IN) {
                    yield ADD_INNER_TYPE;
                }
                yield ADD_OUTER_TYPE;
            }
            case JsonModelV1.JsonModelObject.Type.UNLIT -> UNLIT_TYPE;
            case JsonModelV1.JsonModelObject.Type.FLAT, JsonModelV1.JsonModelObject.Type.DEFAULT -> HILT_TYPE;
            case JsonModelV1.JsonModelObject.Type.FUNCTION -> null;
        };
    }

    public ObjectPartColor getPartColor(JsonModelV1.JsonModelObject.Type type, JsonModelV1.JsonModelObject.Part part) {
        return switch (part) {
            default -> throw new MatchException(null, null);
            case JsonModelV1.JsonModelObject.Part.GRIP -> GRIP_COLOR;
            case JsonModelV1.JsonModelObject.Part.BLADE_IN -> {
                if (type == JsonModelV1.JsonModelObject.Type.ADD) {
                    yield INNER_COLOR;
                }
                yield SIMPLE_INNER_COLOR;
            }
            case JsonModelV1.JsonModelObject.Part.BLADE_OUT -> {
                if (type == JsonModelV1.JsonModelObject.Type.ADD) {
                    yield OUTER_COLOR;
                }
                yield SIMPLE_OUTER_COLOR;
            }
            case JsonModelV1.JsonModelObject.Part.DEFAULT -> DEFAULT_COLOR;
            case JsonModelV1.JsonModelObject.Part.OFF -> OFF_COLOR;
        };
    }

    private boolean isUnlitLight(JsonModelV1.JsonModelObject.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case JsonModelV1.JsonModelObject.Type.ADD, JsonModelV1.JsonModelObject.Type.UNLIT, JsonModelV1.JsonModelObject.Type.FLAT -> true;
            case JsonModelV1.JsonModelObject.Type.DEFAULT, JsonModelV1.JsonModelObject.Type.FUNCTION -> false;
        };
    }

    public int getLightColor(int light) {
        return this.isUnlitLight ? 0xF000F0 : light;
    }

    private void initQuads(String objectName, List<Vector3f> vertices, List<Vector4f> colors, List<Vector3f> normals, List<int[]> faces, JsonModelV1.JsonModelObject object) {
        int from = object.from;
        int size = object.size;
        if (from < 0 || size < 0 || faces.size() < from + size) {
            LOGGER.warn("Incorrect range specified: {}", (Object)objectName);
            return;
        }
        for (int fi = from; fi < from + size; ++fi) {
            int[] face = faces.get(fi);
            for (int i = 0; i < 12; i += 3) {
                if (face[i] < 0 || face[i] >= vertices.size()) {
                    this.warnIndexOutOfBounds(objectName, fi, i);
                    return;
                }
                if (face[i + 1] < 0 || face[i + 1] >= colors.size()) {
                    this.warnIndexOutOfBounds(objectName, fi, i + 1);
                    return;
                }
                if (face[i + 2] >= 0 && face[i + 2] < normals.size()) continue;
                this.warnIndexOutOfBounds(objectName, fi, i + 2);
                return;
            }
            SimpleModel.SimpleQuad quad = new SimpleModel.SimpleQuad(vertices.get(face[0]), colors.get(face[1]), FIXED_UV, normals.get(face[2]), vertices.get(face[3]), colors.get(face[4]), FIXED_UV, normals.get(face[5]), vertices.get(face[6]), colors.get(face[7]), FIXED_UV, normals.get(face[8]), vertices.get(face[9]), colors.get(face[10]), FIXED_UV, normals.get(face[11]));
            this.quads.add(quad);
        }
    }

    private void warnIndexOutOfBounds(String objectName, int faceIndex, int elementIndex) {
        LOGGER.warn("Index is out of bounds: {}faces/{}/{}", new Object[]{objectName, faceIndex, elementIndex});
    }

    @FunctionalInterface
    public static interface ModelObjectFunction {
        public int invoke(RenderingContext var1, int var2);
    }

    @FunctionalInterface
    public static interface ObjectRenderType {
        public RenderType get(SimpleLaserBladeModel var1, LaserBladeItemColor var2, boolean var3);
    }

    @FunctionalInterface
    public static interface ObjectPartColor {
        public int get(LaserBladeItemColor var1, boolean var2);
    }

    public record RenderingContext(ItemStack itemStack, ItemDisplayContext mode, PoseStack matrices) {
    }
}

