/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client.model.laserblade.v1;

import com.github.iunius118.tolaserblade.client.model.laserblade.v1.ModelObject;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

class ModelObjectFunctions {
    public static final ModelObject.ModelObjectFunction FN_NOP = (args, i) -> i;
    public static final ModelObject.ModelObjectFunction FN_ROTATE = (args, i) -> {
        Minecraft minecraft = Minecraft.getInstance();
        IntegratedServer integratedServer = minecraft.getSingleplayerServer();
        float angle = minecraft.isPaused() && integratedServer != null ? (float)(integratedServer.getTickCount() % 5 * 72) : (float)(Util.getMillis() % 250L) * 1.44f;
        PoseStack matrices = args.matrices();
        matrices.pushPose();
        matrices.mulPose((Matrix4fc)new Matrix4f().rotate((float)Math.toRadians(angle), 0.0f, 1.0f, 0.0f));
        return i + 1;
    };
    public static final ModelObject.ModelObjectFunction FN_SHIELD = (args, i) -> {
        PoseStack matrices = args.matrices();
        matrices.pushPose();
        ModelObjectFunctions.transformShield(args.mode(), matrices);
        return i + 1;
    };
    public static final ModelObject.ModelObjectFunction FN_POP_POSE = (args, i) -> {
        if (i > 0) {
            args.matrices().popPose();
            return i - 1;
        }
        return 0;
    };
    private static final Matrix4f FP_RIGHT_HAND_TRANSFORMATION = new Matrix4f(1.06066f, 0.0f, -1.06066f, 0.0f, 1.06066f, 0.0f, 1.06066f, 0.0f, 0.0f, -1.5f, 0.0f, 0.0f, -0.220971f, 0.0f, -0.220971f, 1.0f);
    private static final Matrix4f FP_LEFT_HAND_TRANSFORMATION = new Matrix4f(-1.06066f, 0.0f, -1.06066f, 0.0f, 1.06066f, 0.0f, -1.06066f, 0.0f, 0.0f, -1.5f, 0.0f, 0.0f, -0.110485f, 0.0f, 0.110485f, 1.0f);
    private static final Matrix4f TP_LEFT_HAND_TRANSFORMATION = new Matrix4f(-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.3125f, 0.0f, 1.0f);
    private static final Matrix4f GUI_TRANSFORMATION = new Matrix4f(-0.95f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.95f, 0.0f, 0.0f, 0.95f, 0.0f, 0.0f, 0.15625f, 0.75f, -0.15f, 1.0f);
    private static final Matrix4f GROUND_TRANSFORMATION = new Matrix4f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.275f, -0.275f, 1.0f);

    private ModelObjectFunctions() {
    }

    private static void transformShield(ItemDisplayContext mode, PoseStack matrices) {
        switch (mode) {
            case FIRST_PERSON_RIGHT_HAND: {
                matrices.mulPose((Matrix4fc)FP_RIGHT_HAND_TRANSFORMATION);
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                matrices.mulPose((Matrix4fc)FP_LEFT_HAND_TRANSFORMATION);
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                matrices.mulPose((Matrix4fc)TP_LEFT_HAND_TRANSFORMATION);
                break;
            }
            case GUI: 
            case FIXED: 
            case ON_SHELF: {
                matrices.mulPose((Matrix4fc)GUI_TRANSFORMATION);
                break;
            }
            case GROUND: {
                matrices.mulPose((Matrix4fc)GROUND_TRANSFORMATION);
            }
        }
    }
}

