/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client.model.laserblade.v1;

import com.github.iunius118.tolaserblade.api.client.model.LaserBladeModel;
import com.github.iunius118.tolaserblade.client.model.laserblade.v1.JsonModelV1;
import com.github.iunius118.tolaserblade.client.model.laserblade.v1.LaserBladeModelV1;
import com.github.iunius118.tolaserblade.client.model.laserblade.v1.ModelObject;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.util.ArrayList;
import net.minecraft.util.GsonHelper;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModelParser {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ToLaserBlade.LaserBladeModelVersion1");

    private ModelParser() {
    }

    public static LaserBladeModel parse(String modelName, Reader resourceReader) {
        JsonModelV1 jsonModel = ModelParser.parseModelFromJson(modelName, resourceReader);
        return ModelParser.createLaserBladeModel(modelName, jsonModel);
    }

    private static JsonModelV1 parseModelFromJson(String modelName, Reader reader) {
        try {
            Gson gson = new GsonBuilder().create();
            return (JsonModelV1)GsonHelper.fromJson((Gson)gson, (Reader)reader, JsonModelV1.class);
        }
        catch (JsonParseException e) {
            LOGGER.warn("Failed to load model: {}\n{}", (Object)modelName, (Object)e);
            return null;
        }
    }

    private static LaserBladeModelV1 createLaserBladeModel(String modelName, JsonModelV1 jsonModel) {
        if (jsonModel == null || !"tolaserblade:model_v1".equals(jsonModel.type) || jsonModel.id < 0) {
            return null;
        }
        Vector3f resizeInGUI = null;
        if (jsonModel.guiResize != null) {
            resizeInGUI = ModelParser.getVector3fFromArray(jsonModel.guiResize);
        }
        ArrayList<int[]> faces = new ArrayList<int[]>();
        for (int fi = 0; fi < jsonModel.faces.size(); ++fi) {
            int[] face = jsonModel.faces.get(fi);
            if (face.length != 12) {
                LOGGER.warn("Incorrect face: {}:faces/{}", (Object)modelName, (Object)fi);
                return null;
            }
            faces.add(face);
        }
        ArrayList<Vector3f> vertices = new ArrayList<Vector3f>();
        ArrayList<Vector4f> colors = new ArrayList<Vector4f>();
        ArrayList<Vector3f> normals = new ArrayList<Vector3f>();
        for (float[] vertex : jsonModel.vertices) {
            vertices.add(ModelParser.getVector3fFromArray(vertex));
        }
        for (float[] color : jsonModel.colors) {
            colors.add(ModelParser.getVector4fFromArray(color));
        }
        for (float[] normal : jsonModel.normals) {
            normals.add(ModelParser.getVector3fFromArray(normal));
        }
        ArrayList<ModelObject> modelObjectList = new ArrayList<ModelObject>();
        for (int oi = 0; oi < jsonModel.objects.size(); ++oi) {
            JsonModelV1.JsonModelObject jsonModelObject = jsonModel.objects.get(oi);
            ModelObject modelObject = new ModelObject(modelName + ":objects/" + oi, jsonModelObject, vertices, colors, normals, faces);
            modelObjectList.add(modelObject);
        }
        return new LaserBladeModelV1(modelName, jsonModel.id, resizeInGUI, modelObjectList);
    }

    private static Vector3f getVector3fFromArray(float[] floats) {
        int length = floats.length;
        float[] f = new float[3];
        for (int i = 0; i < 3 && i < length; ++i) {
            f[i] = floats[i];
        }
        return new Vector3f(f);
    }

    private static Vector4f getVector4fFromArray(float[] floats) {
        int length = floats.length;
        float[] f = new float[4];
        for (int i = 0; i < 4 && i < length; ++i) {
            f[i] = floats[i];
        }
        return new Vector4f(f);
    }
}

