/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client.particle;

import com.github.iunius118.tolaserblade.client.particle.LaserTrapParticle;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.model.Model;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleGroup;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.state.ParticleGroupRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ARGB;
import net.minecraft.util.Unit;
import net.minecraft.world.phys.Vec3;

public class LaserTrapParticleGroup
extends ParticleGroup<LaserTrapParticle> {
    public LaserTrapParticleGroup(ParticleEngine particleEngine) {
        super(particleEngine);
    }

    public ParticleGroupRenderState extractRenderState(Frustum frustum, Camera camera, float f) {
        return new State(this.particles.stream().map(particle -> LaserTrapParticleRenderState.fromParticle(particle, camera)).toList());
    }

    record State(List<LaserTrapParticleRenderState> states) implements ParticleGroupRenderState
    {
        public void submit(SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
            for (LaserTrapParticleRenderState state : this.states) {
                submitNodeCollector.submitModel(state.model, (Object)Unit.INSTANCE, state.poseStack, state.renderType, 0xF000F0, OverlayTexture.NO_OVERLAY, state.color, null, 0, null);
            }
        }
    }

    record LaserTrapParticleRenderState(Model<Unit> model, PoseStack poseStack, RenderType renderType, int color) {
        public static LaserTrapParticleRenderState fromParticle(LaserTrapParticle particle, Camera camera) {
            PoseStack poseStack = new PoseStack();
            Vec3 pos = particle.getPosition().subtract(camera.getPosition());
            poseStack.translate(pos.x, pos.y, pos.z);
            int color = ARGB.colorFromFloat((float)1.0f, (float)particle.rCol, (float)particle.gCol, (float)particle.bCol);
            return new LaserTrapParticleRenderState((Model<Unit>)particle.model, poseStack, LaserTrapParticle.RENDER_TYPE, color);
        }
    }
}

