/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client.renderer;

import com.github.iunius118.tolaserblade.client.renderer.LaserBladePipelines;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL14;

public class LaserBladeRenderType {
    private static final BiFunction<String, ResourceLocation, RenderType> TRANSLUCENT = Util.memoize((name, resourceLocation) -> {
        RenderType.CompositeState compositeState = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false)).setLightmapState(RenderType.LIGHTMAP).setOverlayState(RenderType.OVERLAY).createCompositeState(true);
        return RenderType.create((String)name, (int)1536, (boolean)true, (boolean)false, (RenderPipeline)LaserBladePipelines.TRANSLUCENT, (RenderType.CompositeState)compositeState);
    });
    private static final BiFunction<String, ResourceLocation, RenderType> UNLIT_TRANSLUCENT = Util.memoize((name, resourceLocation) -> {
        RenderType.CompositeState compositeState = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false)).setLightmapState(RenderType.LIGHTMAP).setOverlayState(RenderType.OVERLAY).createCompositeState(true);
        return RenderType.create((String)name, (int)1536, (boolean)true, (boolean)false, (RenderPipeline)LaserBladePipelines.UNLIT_TRANSLUCENT, (RenderType.CompositeState)compositeState);
    });
    private static final BiFunction<String, ResourceLocation, RenderType> ADD = Util.memoize((name, resourceLocation) -> {
        RenderType.CompositeState compositeState = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false)).setLightmapState(RenderType.LIGHTMAP).setOverlayState(RenderType.OVERLAY).createCompositeState(true);
        return RenderType.create((String)name, (int)1536, (boolean)true, (boolean)false, (RenderPipeline)LaserBladePipelines.ADD, (RenderType.CompositeState)compositeState);
    });
    private static final BiFunction<String, ResourceLocation, RenderType> SUB = Util.memoize((name, resourceLocation) -> {
        RenderStateShard.TexturingStateShard tlbSubColor = new RenderStateShard.TexturingStateShard("tolaserblade:lb_sub_color", () -> GL14.glBlendEquation((int)32779), () -> GL14.glBlendEquation((int)32774));
        RenderType.CompositeState compositeState = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false)).setTexturingState(tlbSubColor).setLightmapState(RenderType.LIGHTMAP).setOverlayState(RenderType.OVERLAY).createCompositeState(true);
        return RenderType.create((String)name, (int)1536, (boolean)true, (boolean)false, (RenderPipeline)LaserBladePipelines.ADD, (RenderType.CompositeState)compositeState);
    });

    public static RenderType getHiltRenderType(String name, ResourceLocation texture) {
        return TRANSLUCENT.apply(name, texture);
    }

    public static RenderType getUnlitRenderType(String name, ResourceLocation texture) {
        return UNLIT_TRANSLUCENT.apply(name, texture);
    }

    public static RenderType getAddRenderType(String name, ResourceLocation texture) {
        return ADD.apply(name, texture);
    }

    public static RenderType getSubRenderType(String name, ResourceLocation texture) {
        return SUB.apply(name, texture);
    }

    private LaserBladeRenderType() {
    }
}

