/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.common;

import com.github.iunius118.tolaserblade.client.ClientModEventHandler;
import com.github.iunius118.tolaserblade.config.TLBClientConfig;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeBlocking;
import com.github.iunius118.tolaserblade.world.item.LaserBladeItemBase;
import com.github.iunius118.tolaserblade.world.item.LaserBladeItemUtil;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.PlayLevelSoundEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class CommonEventHandler {
    public static boolean hasShownUpdate = false;

    @SubscribeEvent
    public static void onEntityJoiningInWorld(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide() && event.getEntity() instanceof Player && TLBClientConfig.showUpdateMessage && !hasShownUpdate) {
            ClientModEventHandler.checkUpdate();
            hasShownUpdate = true;
        }
    }

    @SubscribeEvent
    public static void onPlayLevelSoundAtPosition(PlayLevelSoundEvent.AtPosition event) {
        if (event.getLevel().isClientSide() && LaserBladeBlocking.isBlockingSound((Holder<SoundEvent>)event.getSound())) {
            LaserBladeItemUtil.playBlockSound(event);
        }
    }

    @SubscribeEvent
    public static void onItemTooltipEvent(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.getItem();
        if (item instanceof LaserBladeItemBase) {
            LaserBladeItemBase item2 = (LaserBladeItemBase)item;
            item2.appendTooltip(itemStack, event.getContext(), event.getFlags(), event.getToolTip());
        }
    }
}

