/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.common;

import com.github.iunius118.tolaserblade.common.util.ModSoundEventRegistry;
import com.github.iunius118.tolaserblade.core.component.ModDataComponents;
import com.github.iunius118.tolaserblade.core.component.predicates.ModDataComponentPredicates;
import com.github.iunius118.tolaserblade.core.particle.ModParticleTypes;
import com.github.iunius118.tolaserblade.world.item.ModCreativeModeTabs;
import com.github.iunius118.tolaserblade.world.item.ModItemRegistry;
import com.github.iunius118.tolaserblade.world.item.crafting.ModRecipeSerializers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RegistryEventHandler {
    public static void registerGameObjects(IEventBus modEventBus) {
        RegistryEventHandler.registerRecipeSerializers(modEventBus);
        RegistryEventHandler.registerItems(modEventBus);
        RegistryEventHandler.registerParticleTypes(modEventBus);
        RegistryEventHandler.registerSoundEvents(modEventBus);
        RegistryEventHandler.registerCreativeModeTabs(modEventBus);
        RegistryEventHandler.registerDataComponentTypes(modEventBus);
        RegistryEventHandler.registerDataComponentPredicateTypes(modEventBus);
    }

    private static void registerRecipeSerializers(IEventBus modEventBus) {
        DeferredRegister recipeSerializerRegister = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"tolaserblade");
        recipeSerializerRegister.register("upgrade", () -> ModRecipeSerializers.UPGRADE);
        recipeSerializerRegister.register("color", () -> ModRecipeSerializers.COLOR);
        recipeSerializerRegister.register("model_change", () -> ModRecipeSerializers.MODEL_CHANGE);
        recipeSerializerRegister.register(modEventBus);
    }

    private static void registerItems(IEventBus modEventBus) {
        ModItemRegistry.register(modEventBus);
    }

    private static void registerParticleTypes(IEventBus modEventBus) {
        DeferredRegister particleTypeRegister = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)"tolaserblade");
        particleTypeRegister.register("laser_trap_x", () -> ModParticleTypes.LASER_TRAP_X);
        particleTypeRegister.register("laser_trap_y", () -> ModParticleTypes.LASER_TRAP_Y);
        particleTypeRegister.register("laser_trap_z", () -> ModParticleTypes.LASER_TRAP_Z);
        particleTypeRegister.register(modEventBus);
    }

    private static void registerSoundEvents(IEventBus modEventBus) {
        ModSoundEventRegistry.register(modEventBus);
    }

    private static void registerCreativeModeTabs(IEventBus modEventBus) {
        DeferredRegister creativeModeTabRegister = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"tolaserblade");
        creativeModeTabRegister.register("general", () -> ModCreativeModeTabs.TAB_LASER_BLADE);
        creativeModeTabRegister.register(modEventBus);
    }

    private static void registerDataComponentTypes(IEventBus modEventBus) {
        DeferredRegister dataComponentTypeRegister = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"tolaserblade");
        dataComponentTypeRegister.register("lb_atk", () -> ModDataComponents.LASER_BLADE_ATTACK);
        dataComponentTypeRegister.register("lb_spd", () -> ModDataComponents.LASER_BLADE_SPEED);
        dataComponentTypeRegister.register("lb_mdl", () -> ModDataComponents.LASER_BLADE_MODEL);
        dataComponentTypeRegister.register(modEventBus);
    }

    private static void registerDataComponentPredicateTypes(IEventBus modEventBus) {
        DeferredRegister dataComponentPredicateTypeRegister = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_PREDICATE_TYPE, (String)"tolaserblade");
        dataComponentPredicateTypeRegister.register("lb_atk", () -> ModDataComponentPredicates.LASER_BLADE_ATTACK);
        dataComponentPredicateTypeRegister.register("lb_spd", () -> ModDataComponentPredicates.LASER_BLADE_SPEED);
        dataComponentPredicateTypeRegister.register(modEventBus);
    }
}

