/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.common.util;

import com.github.iunius118.tolaserblade.common.util.Color4F;
import com.github.iunius118.tolaserblade.common.util.ModSoundEvents;
import com.github.iunius118.tolaserblade.config.TLBServerConfig;
import com.github.iunius118.tolaserblade.core.laserblade.LaserBladeAppearance;
import com.github.iunius118.tolaserblade.core.particle.ModParticleTypes;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;

public class LaserTrapPlayer
extends FakePlayer {
    private static final GameProfile PROFILE = new GameProfile(UUID.fromString("2BDD19A3-9616-417A-8797-EE805F5FF9E3"), "[LaserBlade]");

    private LaserTrapPlayer(ServerLevel level, GameProfile name) {
        super(level, name);
    }

    public static void attackEntities(ServerLevel serverLevel, BlockPos trapPos, ItemStack itemStackHeld, Direction dir) {
        LaserTrapPlayer laserTrapPlayer = LaserTrapPlayer.get(serverLevel, trapPos, itemStackHeld);
        laserTrapPlayer.attackEntities(dir);
        laserTrapPlayer.remove(Entity.RemovalReason.DISCARDED);
    }

    public static LaserTrapPlayer get(ServerLevel serverLevel, BlockPos trapPos, ItemStack itemStackHeld) {
        LaserTrapPlayer laserTrapPlayer = new LaserTrapPlayer(serverLevel, PROFILE);
        laserTrapPlayer.setPos((double)trapPos.getX() + 0.5, trapPos.getY(), (double)trapPos.getZ() + 0.5);
        laserTrapPlayer.initInventory(itemStackHeld.copy());
        return laserTrapPlayer;
    }

    public void initInventory(ItemStack currentStack) {
        Inventory inventory = this.getInventory();
        inventory.clearContent();
        inventory.setSelectedSlot(0);
        inventory.setItem(0, currentStack);
        AttributeMap attributeMap = this.getAttributes();
        currentStack.forEachModifier(EquipmentSlot.MAINHAND, (holder, attributeModifier) -> {
            AttributeInstance attributeInstance = attributeMap.getInstance(holder);
            if (attributeInstance != null) {
                attributeInstance.removeModifier(attributeModifier.id());
                attributeInstance.addTransientModifier(attributeModifier);
            }
        });
    }

    public void attackEntities(Direction dir) {
        BlockPos trapPos = this.blockPosition();
        BlockPos targetPos = trapPos.relative(dir);
        AABB aabb = new AABB(targetPos).inflate(0.5);
        ServerLevel level = this.level();
        List targetEntities = level.getEntities((Entity)null, aabb, this::canHitEntity);
        float attackDamage = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        Optional fireAspect = level.holderLookup(Registries.ENCHANTMENT).get(Enchantments.FIRE_ASPECT);
        int fireLevel = fireAspect.map(e -> EnchantmentHelper.getEnchantmentLevel((Holder)e, (LivingEntity)this)).orElse(0);
        ItemStack itemStack = this.getMainHandItem();
        for (Entity targetEntity : targetEntities) {
            float totalDamage = EnchantmentHelper.modifyDamage((ServerLevel)level, (ItemStack)itemStack, (Entity)targetEntity, (DamageSource)this.damageSources().playerAttack((Player)this), (float)attackDamage);
            if (this.canBurn(targetEntity, fireLevel)) {
                targetEntity.igniteForSeconds((float)Math.min(fireLevel, 1));
            }
            targetEntity.hurtServer(level, this.damageSources().playerAttack((Player)this), totalDamage);
        }
        this.addEffect(dir, targetPos, itemStack);
    }

    private boolean canHitEntity(Entity entity) {
        if (!entity.isSpectator() && entity.isAlive() && entity.isPickable()) {
            return TLBServerConfig.canLaserTrapAttackPlayer || !(entity instanceof Player);
        }
        return false;
    }

    private boolean canBurn(Entity entity, int fireAspectLevel) {
        return fireAspectLevel > 0 && (entity instanceof Mob || entity instanceof Player);
    }

    private void addEffect(Direction dir, BlockPos effectPos, ItemStack itemStack) {
        ServerLevel serverLevel = this.level();
        if (!(serverLevel instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel2 = serverLevel;
        SimpleParticleType laserTrapParticleType = ModParticleTypes.getLaserTrapParticleType(dir.getAxis());
        Vec3 vecPos = new Vec3((double)effectPos.getX(), (double)effectPos.getY(), (double)effectPos.getZ()).add(0.5, 0.5, 0.5);
        Color4F color = this.getParticleColor(itemStack);
        serverLevel2.sendParticles((ParticleOptions)laserTrapParticleType, vecPos.x, vecPos.y, vecPos.z, 0, (double)color.r(), (double)color.g(), (double)color.b(), 1.0);
        serverLevel2.playSound(null, vecPos.x, vecPos.y, vecPos.z, ModSoundEvents.ITEM_LASER_TRAP_ACTIVATE, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    private Color4F getParticleColor(ItemStack itemStack) {
        LaserBladeAppearance appearance = LaserBladeAppearance.of(itemStack);
        int outerColor = appearance.getOuterColor();
        if (appearance.isOuterSubColor()) {
            outerColor ^= 0xFFFFFFFF;
        }
        return Color4F.of(outerColor | 0xFF000000);
    }
}

